/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedExecutorService
implements ExecutorService {
    private static final String NOT_ALLOWED = "Shutdown of shared executor is not allowed";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executor;
    private MetricsService metricsService = null;
    private MetricsComponent executorMetrics;
    private Timer queueMetrics = null;
    private Timer delayMetrics = null;

    SharedExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    ExecutorService backingExecutor() {
        return this.executor;
    }

    void setBackingExecutor(ExecutorService executor) {
        ExecutorService oldExecutor = this.executor;
        this.executor = executor;
        oldExecutor.shutdown();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException(NOT_ALLOWED);
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException(NOT_ALLOWED);
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Counter taskCounter = new Counter();
        taskCounter.reset();
        return this.executor.submit(() -> {
            Object t = null;
            long queueWaitTime = (long)taskCounter.duration();
            Class<?> className = task instanceof CallableExtended ? ((CallableExtended)task).getRunnable().getClass() : task.getClass();
            if (this.queueMetrics != null) {
                this.queueMetrics.update(queueWaitTime, TimeUnit.SECONDS);
            }
            taskCounter.reset();
            try {
                t = task.call();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(className).error("Uncaught exception on " + className, (Throwable)e);
            }
            long taskwaittime = (long)taskCounter.duration();
            if (this.delayMetrics != null) {
                this.delayMetrics.update(taskwaittime, TimeUnit.SECONDS);
            }
            return t;
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public void setMetricsService(MetricsService metricsService) {
        if (this.metricsService == null && metricsService != null) {
            this.executorMetrics = metricsService.registerComponent("SharedExecutor");
            MetricsFeature mf = this.executorMetrics.registerFeature("*");
            this.queueMetrics = metricsService.createTimer(this.executorMetrics, mf, "Queue");
            this.delayMetrics = metricsService.createTimer(this.executorMetrics, mf, "Delay");
        } else if (this.metricsService != null && metricsService == null) {
            this.queueMetrics = null;
            this.delayMetrics = null;
        }
        this.metricsService = metricsService;
    }

    private Runnable wrap(Runnable command) {
        return new LoggableRunnable(command);
    }

    class CallableExtended
    implements Callable {
        private Runnable runnable;

        public CallableExtended(Runnable runnable) {
            this.runnable = runnable;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Object call() throws Exception {
            this.runnable.run();
            return null;
        }
    }

    private class LoggableRunnable
    implements Runnable {
        private Runnable runnable;

        public LoggableRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                SharedExecutorService.this.log.error("Uncaught exception on " + this.runnable.getClass().getSimpleName(), (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }
}

