/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.util.SharedScheduledExecutorService;
import org.onlab.util.Tools;

public final class SharedScheduledExecutors {
    public static final int DEFAULT_POOL_SIZE = 30;
    private static final Object EXECUTORS_LOCK = new Object();
    private static SharedScheduledExecutorService singleThreadExecutor = null;
    private static SharedScheduledExecutorService poolThreadExecutor = null;

    private SharedScheduledExecutors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setup() {
        Object object = EXECUTORS_LOCK;
        synchronized (object) {
            if (singleThreadExecutor == null) {
                singleThreadExecutor = new SharedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads("onos/shared/scheduled", "onos-single-executor")));
                poolThreadExecutor = new SharedScheduledExecutorService(Executors.newScheduledThreadPool(30, Tools.groupedThreads("onos/shared/scheduled", "onos-pool-executor-%d")));
            }
        }
    }

    public static SharedScheduledExecutorService getSingleThreadExecutor() {
        SharedScheduledExecutors.setup();
        return singleThreadExecutor;
    }

    public static ScheduledFuture<?> newTimeout(Runnable task, long delay, TimeUnit unit) {
        SharedScheduledExecutors.setup();
        return SharedScheduledExecutors.getPoolThreadExecutor().schedule(task, delay, unit);
    }

    public static SharedScheduledExecutorService getPoolThreadExecutor() {
        SharedScheduledExecutors.setup();
        return poolThreadExecutor;
    }

    public static void setPoolSize(int poolSize) {
        SharedScheduledExecutors.setup();
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Shared pool size size must be greater than 0");
        poolThreadExecutor.setBackingExecutor(Executors.newScheduledThreadPool(poolSize, Tools.groupedThreads("onos/shared/scheduled", "onos-pool-executor-%d")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = EXECUTORS_LOCK;
        synchronized (object) {
            if (singleThreadExecutor != null) {
                singleThreadExecutor.backingExecutor().shutdown();
                singleThreadExecutor = null;
                poolThreadExecutor.backingExecutor().shutdown();
                poolThreadExecutor = null;
            }
        }
    }
}

