/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.DefaultHashMap;

public class DefaultHashMapTest {
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String THREE = "three";
    private static final String FOUR = "four";
    private static final String ALPHA = "Alpha";
    private static final String BETA = "Beta";
    private static final String OMEGA = "Omega";
    private DefaultHashMap<String, Integer> map;
    private DefaultHashMap<String, String> chartis;

    private void loadMap() {
        this.map.put((Object)ONE, (Object)1);
        this.map.put((Object)TWO, (Object)2);
    }

    private void fortioCharti() {
        this.chartis.put((Object)ONE, (Object)ALPHA);
        this.chartis.put((Object)TWO, (Object)BETA);
    }

    @Test
    public void nullDefaultIsAllowed() {
        this.map = new DefaultHashMap(null);
        this.loadMap();
        Assert.assertEquals((String)"missing 1", (long)1L, (long)((Integer)this.map.get((Object)ONE)).intValue());
        Assert.assertEquals((String)"missing 2", (long)2L, (long)((Integer)this.map.get((Object)TWO)).intValue());
        Assert.assertEquals((String)"three?", null, (Object)this.map.get((Object)THREE));
        Assert.assertEquals((String)"four?", null, (Object)this.map.get((Object)FOUR));
    }

    @Test
    public void defaultToFive() {
        this.map = new DefaultHashMap((Object)5);
        this.loadMap();
        Assert.assertEquals((String)"missing 1", (long)1L, (long)((Integer)this.map.get((Object)ONE)).intValue());
        Assert.assertEquals((String)"missing 2", (long)2L, (long)((Integer)this.map.get((Object)TWO)).intValue());
        Assert.assertEquals((String)"three?", (long)5L, (long)((Integer)this.map.get((Object)THREE)).intValue());
        Assert.assertEquals((String)"four?", (long)5L, (long)((Integer)this.map.get((Object)FOUR)).intValue());
    }

    @Test
    public void defaultToOmega() {
        this.chartis = new DefaultHashMap((Object)OMEGA);
        this.fortioCharti();
        Assert.assertEquals((String)"missing 1", (Object)ALPHA, (Object)this.chartis.get((Object)ONE));
        Assert.assertEquals((String)"missing 2", (Object)BETA, (Object)this.chartis.get((Object)TWO));
        Assert.assertEquals((String)"three?", (Object)OMEGA, (Object)this.chartis.get((Object)THREE));
        Assert.assertEquals((String)"four?", (Object)OMEGA, (Object)this.chartis.get((Object)FOUR));
    }
}

