/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.RandomUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.util.ImmutableByteSequence;

public class ImmutableByteSequenceTest {
    public static final int MIN_RAND_FIT_VALUE = 15;
    public static final int MAX_RAND_FIT_VALUE = Integer.MAX_VALUE;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCopy() throws Exception {
        byte byteValue = 1;
        short shortValue = byteValue;
        byte intValue = byteValue;
        long longValue = byteValue;
        byte[] arrayValue = new byte[64];
        arrayValue[63] = byteValue;
        ByteBuffer bufferValue = ByteBuffer.allocate(64).put(arrayValue);
        ImmutableByteSequence bsByte = ImmutableByteSequence.copyFrom((byte)byteValue);
        ImmutableByteSequence bsShort = ImmutableByteSequence.copyFrom((short)shortValue);
        ImmutableByteSequence bsInt = ImmutableByteSequence.copyFrom((int)intValue);
        ImmutableByteSequence bsLong = ImmutableByteSequence.copyFrom((long)longValue);
        ImmutableByteSequence bsArray = ImmutableByteSequence.copyFrom((byte[])arrayValue);
        ImmutableByteSequence bsBuffer = ImmutableByteSequence.copyFrom((ByteBuffer)bufferValue);
        MatcherAssert.assertThat((String)"byte sequence of a byte value must have size 1", (Object)bsByte.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((String)"byte sequence of a short value must have size 2", (Object)bsShort.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        MatcherAssert.assertThat((String)"byte sequence of an int value must have size 4", (Object)bsInt.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4)));
        MatcherAssert.assertThat((String)"byte sequence of a long value must have size 8", (Object)bsLong.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)8)));
        MatcherAssert.assertThat((String)"byte sequence of a byte array value must have same size of the array", (Object)bsArray.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)arrayValue.length)));
        MatcherAssert.assertThat((String)"byte sequence of a byte buffer value must have same size of the buffer", (Object)bsBuffer.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bufferValue.capacity())));
        String errStr = "incorrect byte sequence value";
        MatcherAssert.assertThat((String)errStr, (Object)bsByte.asArray()[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsShort.asArray()[1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsInt.asArray()[3], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsLong.asArray()[7], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsArray.asArray()[63], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsBuffer.asArray()[63], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
    }

    @Test
    public void testCopyAndFit() throws Exception {
        int originalByteWidth = 3;
        int paddedByteWidth = 4;
        int trimmedByteWidth = 2;
        int indexFirstNonZeroByte = 1;
        byte byteValue = 1;
        byte[] arrayValue = new byte[originalByteWidth];
        arrayValue[indexFirstNonZeroByte] = byteValue;
        ByteBuffer bufferValue = ByteBuffer.allocate(originalByteWidth).put(arrayValue);
        ImmutableByteSequence bsBuffer = ImmutableByteSequence.copyAndFit((ByteBuffer)bufferValue, (int)(originalByteWidth * 8));
        ImmutableByteSequence bsBufferTrimmed = ImmutableByteSequence.copyAndFit((ByteBuffer)bufferValue, (int)(trimmedByteWidth * 8));
        ImmutableByteSequence bsBufferPadded = ImmutableByteSequence.copyAndFit((ByteBuffer)bufferValue, (int)(paddedByteWidth * 8));
        MatcherAssert.assertThat((String)"byte sequence of the byte buffer must be 3 bytes long", (Object)bsBuffer.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)originalByteWidth)));
        MatcherAssert.assertThat((String)"byte sequence of the byte buffer must be 3 bytes long", (Object)bsBufferTrimmed.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)trimmedByteWidth)));
        MatcherAssert.assertThat((String)"byte sequence of the byte buffer must be 3 bytes long", (Object)bsBufferPadded.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)paddedByteWidth)));
        String errStr = "incorrect byte sequence value";
        MatcherAssert.assertThat((String)errStr, (Object)bsBuffer.asArray()[indexFirstNonZeroByte], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsBufferTrimmed.asArray()[indexFirstNonZeroByte - 1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsBufferPadded.asArray()[indexFirstNonZeroByte + 1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)byteValue)));
        MatcherAssert.assertThat((String)errStr, (Object)bsBufferPadded.asArray()[paddedByteWidth - 1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testCopyAndFitEndianness() throws Exception {
        int originalByteWidth = 4;
        int indexByteNonZeroBig = 1;
        int indexByteNonZeroLittle = 2;
        byte byteValue = 1;
        ByteBuffer bbBigEndian = ByteBuffer.allocate(originalByteWidth).order(ByteOrder.BIG_ENDIAN);
        bbBigEndian.put(indexByteNonZeroBig, byteValue);
        ImmutableByteSequence bsBufferCopyBigEndian = ImmutableByteSequence.copyAndFit((ByteBuffer)bbBigEndian, (int)(originalByteWidth * 8));
        ByteBuffer bbLittleEndian = ByteBuffer.allocate(originalByteWidth).order(ByteOrder.LITTLE_ENDIAN);
        bbLittleEndian.put(indexByteNonZeroLittle, byteValue);
        ImmutableByteSequence bsBufferCopyLittleEndian = ImmutableByteSequence.copyAndFit((ByteBuffer)bbLittleEndian, (int)(originalByteWidth * 8));
        byte[] arrayValue = new byte[originalByteWidth];
        arrayValue[indexByteNonZeroBig] = byteValue;
        ImmutableByteSequence bsArrayCopy = ImmutableByteSequence.copyFrom((byte[])arrayValue);
        new EqualsTester().addEqualityGroup(new Object[]{bbBigEndian.array()}).addEqualityGroup(new Object[]{bbLittleEndian.array()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian, bsBufferCopyLittleEndian, bsArrayCopy}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer(), bsBufferCopyLittleEndian.asReadOnlyBuffer(), bsArrayCopy.asReadOnlyBuffer()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer().order(), bsBufferCopyLittleEndian.asReadOnlyBuffer().order(), bsArrayCopy.asReadOnlyBuffer().order(), ByteOrder.BIG_ENDIAN}).testEquals();
    }

    @Test
    public void testIllegalCopyAndFit() throws Exception {
        int originalByteWidth = 3;
        int trimmedByteWidth = 1;
        int indexFirstNonZeroByte = 1;
        byte byteValue = 1;
        byte[] arrayValue = new byte[originalByteWidth];
        arrayValue[indexFirstNonZeroByte] = byteValue;
        ByteBuffer bufferValue = ByteBuffer.allocate(originalByteWidth).put(arrayValue);
        try {
            ImmutableByteSequence.copyAndFit((ByteBuffer)bufferValue, (int)(trimmedByteWidth * 8));
            Assert.fail((String)String.format("Expect ByteSequenceTrimException due to value = %s and bitWidth %d", Arrays.toString(arrayValue), trimmedByteWidth * 8));
        }
        catch (ImmutableByteSequence.ByteSequenceTrimException byteSequenceTrimException) {
            // empty catch block
        }
    }

    @Test
    public void testEndianness() throws Exception {
        long longValue = RandomUtils.nextLong();
        ByteBuffer bbBigEndian = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(longValue);
        ImmutableByteSequence bsBufferCopyBigEndian = ImmutableByteSequence.copyFrom((ByteBuffer)bbBigEndian);
        ByteBuffer bbLittleEndian = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(longValue);
        ImmutableByteSequence bsBufferCopyLittleEndian = ImmutableByteSequence.copyFrom((ByteBuffer)bbLittleEndian);
        ImmutableByteSequence bsLongCopy = ImmutableByteSequence.copyFrom((long)longValue);
        new EqualsTester().addEqualityGroup(new Object[]{bbBigEndian.array()}).addEqualityGroup(new Object[]{bbLittleEndian.array()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian, bsBufferCopyLittleEndian, bsLongCopy}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer(), bsBufferCopyLittleEndian.asReadOnlyBuffer(), bsLongCopy.asReadOnlyBuffer()}).addEqualityGroup(new Object[]{bsBufferCopyBigEndian.asReadOnlyBuffer().order(), bsBufferCopyLittleEndian.asReadOnlyBuffer().order(), bsLongCopy.asReadOnlyBuffer().order(), ByteOrder.BIG_ENDIAN}).testEquals();
    }

    @Test
    public void testBitSetMethods() throws Exception {
        MatcherAssert.assertThat((String)"3 bytes, all 0's", (Object)ImmutableByteSequence.ofZeros((int)3), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 0's via prefix", (Object)ImmutableByteSequence.prefixZeros((int)3, (long)24L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 1's", (Object)ImmutableByteSequence.ofZeros((int)3), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0}))));
        MatcherAssert.assertThat((String)"3 bytes, all 1's via prefix", (Object)ImmutableByteSequence.prefixOnes((int)3, (long)24L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, -1}))));
        MatcherAssert.assertThat((String)"2 bytes, prefixed with 5 0's", (Object)ImmutableByteSequence.prefix((int)2, (long)5L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{7, -1}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 16 0's", (Object)ImmutableByteSequence.prefix((int)4, (long)16L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, -1, -1}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 20 0's", (Object)ImmutableByteSequence.prefix((int)4, (long)20L, (byte)0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 15, -1}))));
        MatcherAssert.assertThat((String)"8 bytes, prefixed with 36 0's", (Object)ImmutableByteSequence.prefixZeros((int)8, (long)38L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{0, 0, 0, 0, 3, -1, -1, -1}))));
        MatcherAssert.assertThat((String)"2 bytes, prefixed with 5 1's", (Object)ImmutableByteSequence.prefix((int)2, (long)5L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-8, 0}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 16 1's", (Object)ImmutableByteSequence.prefix((int)4, (long)16L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, 0, 0}))));
        MatcherAssert.assertThat((String)"4 bytes, prefixed with 20 1's", (Object)ImmutableByteSequence.prefix((int)4, (long)20L, (byte)-1), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -1, -16, 0}))));
        MatcherAssert.assertThat((String)"8 bytes, prefixed with 10 1's", (Object)ImmutableByteSequence.prefixOnes((int)8, (long)10L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ImmutableByteSequence.copyFrom((byte[])new byte[]{-1, -64, 0, 0, 0, 0, 0, 0}))));
    }

    @Test
    public void testBadPrefixVal() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.reportMissingExceptionWithMessage("Expect IllegalArgumentException due to val = 0x7");
        ImmutableByteSequence.prefix((int)5, (long)10L, (byte)7);
    }

    @Test
    public void testMsbIndex() {
        MatcherAssert.assertThat((String)"Value 0 should have MSB index -1", (Object)ImmutableByteSequence.copyFrom((int)0).msbIndex(), (Matcher)Matchers.is((Object)-1));
        for (int i = 0; i < 63; ++i) {
            long value = (long)Math.pow(2.0, i);
            MatcherAssert.assertThat((String)String.format("Value %d should have MSB index %d", value, i), (Object)ImmutableByteSequence.copyFrom((long)value).msbIndex(), (Matcher)Matchers.is((Object)i));
        }
    }

    private void checkIllegalFit(ImmutableByteSequence bytes, int bitWidth) {
        try {
            bytes.fit(bitWidth);
            Assert.fail((String)String.format("Except ByteSequenceTrimException due to value = %s and bitWidth %d", bytes.toString(), bitWidth));
        }
        catch (ImmutableByteSequence.ByteSequenceTrimException byteSequenceTrimException) {
            // empty catch block
        }
    }

    private void checkLegalFit(ImmutableByteSequence bytes, int bitWidth) throws ImmutableByteSequence.ByteSequenceTrimException {
        ImmutableByteSequence fitBytes = bytes.fit(bitWidth);
        ImmutableByteSequence sameBytes = fitBytes.fit(bytes.size() * 8);
        MatcherAssert.assertThat((String)String.format("Fitted value %s (re-extended to %s) not equal to original value %s", fitBytes, sameBytes, bytes), (Object)sameBytes, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bytes)));
    }

    @Test
    public void testFit() throws ImmutableByteSequence.ByteSequenceTrimException {
        for (int msbIndex = 0; msbIndex < 32; ++msbIndex) {
            long value = (long)Math.pow(2.0, msbIndex);
            ImmutableByteSequence bytes = ImmutableByteSequence.copyFrom((long)value);
            this.checkLegalFit(bytes, msbIndex + 1);
            if (msbIndex == 0) continue;
            this.checkIllegalFit(bytes, msbIndex);
        }
    }

    @Test
    public void testRandomFit() throws ImmutableByteSequence.ByteSequenceTrimException {
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int randValue = random.nextInt(0x7FFFFFF1) + 15;
            ImmutableByteSequence bytes = ImmutableByteSequence.copyFrom((long)randValue);
            int msbIndex = bytes.msbIndex();
            this.checkIllegalFit(bytes, Integer.max(msbIndex - random.nextInt(16), 1));
            this.checkLegalFit(bytes, msbIndex + 2 + random.nextInt(128));
            this.checkLegalFit(bytes, msbIndex + 1);
        }
    }

    @Test
    public void testBitwiseOperations() {
        Random random = new Random();
        long long1 = random.nextLong();
        long long2 = random.nextLong();
        ImmutableByteSequence bs1 = ImmutableByteSequence.copyFrom((long)long1);
        ImmutableByteSequence bs2 = ImmutableByteSequence.copyFrom((long)long2);
        ImmutableByteSequence andBs = bs1.bitwiseAnd(bs2);
        ImmutableByteSequence orBs = bs1.bitwiseOr(bs2);
        ImmutableByteSequence xorBs = bs1.bitwiseXor(bs2);
        MatcherAssert.assertThat((String)"Invalid bitwise AND result", (Object)andBs.asReadOnlyBuffer().getLong(), (Matcher)Matchers.is((Object)(long1 & long2)));
        MatcherAssert.assertThat((String)"Invalid bitwise OR result", (Object)orBs.asReadOnlyBuffer().getLong(), (Matcher)Matchers.is((Object)(long1 | long2)));
        MatcherAssert.assertThat((String)"Invalid bitwise XOR result", (Object)xorBs.asReadOnlyBuffer().getLong(), (Matcher)Matchers.is((Object)(long1 ^ long2)));
    }
}

