/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMPEcho;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;

public class ICMPEchoTest {
    private Deserializer<ICMPEcho> deserializer;
    protected byte icmpType = (byte)8;
    protected byte icmpCode = 0;
    protected short checksum = (short)870;
    private short identifier = 1;
    private short sequenceNum = (short)2;
    private MacAddress srcMac = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private IpAddress srcIp = IpAddress.valueOf((String)"10.0.0.3");
    private MacAddress dstMac = MacAddress.valueOf((String)"66:55:44:33:22:11");
    private IpAddress dstIp = IpAddress.valueOf((String)"10.0.0.1");
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = ICMPEcho.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putShort(this.identifier);
        bb.putShort(this.sequenceNum);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.headerBytes);
    }

    @Test
    public void testIcmpEchoPacket() throws Exception {
        ICMPEcho icmpEcho = new ICMPEcho();
        icmpEcho.setIdentifier(this.identifier);
        icmpEcho.setSequenceNum(this.sequenceNum);
        ByteBuffer bb = ByteBuffer.wrap(icmpEcho.serialize());
        ICMPEcho deserializedIcmpEcho = (ICMPEcho)this.deserializer.deserialize(bb.array(), 0, bb.array().length);
        Assert.assertTrue((boolean)deserializedIcmpEcho.equals((Object)icmpEcho));
        Assert.assertEquals((long)deserializedIcmpEcho.getIdentifier(), (long)icmpEcho.getIdentifier());
        Assert.assertEquals((long)deserializedIcmpEcho.getSequenceNum(), (long)icmpEcho.getSequenceNum());
    }

    @Test
    public void testDeserializeFromIpPacket() throws Exception {
        ICMPEcho icmpEcho = new ICMPEcho();
        icmpEcho.setIdentifier(this.identifier).setSequenceNum(this.sequenceNum);
        ByteBuffer byteBufferIcmpEcho = ByteBuffer.wrap(icmpEcho.serialize());
        ICMP icmp = new ICMP();
        icmp.setIcmpType(this.icmpType).setIcmpCode(this.icmpCode).setChecksum(this.checksum);
        icmp.setPayload(ICMPEcho.deserializer().deserialize(byteBufferIcmpEcho.array(), 0, 4));
        ByteBuffer byteBufferIcmp = ByteBuffer.wrap(icmp.serialize());
        IPv4 iPacket = new IPv4();
        iPacket.setDestinationAddress(this.dstIp.toString());
        iPacket.setSourceAddress(this.srcIp.toString());
        iPacket.setTtl((byte)64);
        iPacket.setChecksum((short)0);
        iPacket.setDiffServ((byte)0);
        iPacket.setProtocol((byte)1);
        iPacket.setPayload(ICMP.deserializer().deserialize(byteBufferIcmp.array(), 0, byteBufferIcmp.array().length));
        Ethernet ethPacket = new Ethernet();
        ethPacket.setEtherType(Ethernet.TYPE_IPV4);
        ethPacket.setSourceMACAddress(this.srcMac);
        ethPacket.setDestinationMACAddress(this.dstMac);
        ethPacket.setPayload((IPacket)iPacket);
        this.validatePacket(ethPacket);
    }

    private void validatePacket(Ethernet ethPacket) {
        ICMP icmp = (ICMP)ethPacket.getPayload().getPayload();
        ICMPEcho icmpEcho = (ICMPEcho)icmp.getPayload();
        Assert.assertEquals((long)icmp.getIcmpType(), (long)this.icmpType);
        Assert.assertEquals((long)icmp.getIcmpCode(), (long)this.icmpCode);
        Assert.assertEquals((long)icmp.getChecksum(), (long)this.checksum);
        Assert.assertEquals((long)icmpEcho.getIdentifier(), (long)this.identifier);
        Assert.assertEquals((long)icmpEcho.getSequenceNum(), (long)this.sequenceNum);
    }
}

