/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.Ethernet;
import org.onlab.packet.PPPoED;
import org.onlab.packet.PPPoEDTag;
import org.onlab.packet.PacketTestUtils;

public class PPPoEDTest {
    private static final byte VERSION = 1;
    private static final byte TYPE = 1;
    private static final short NO_SESSION = 0;
    private static final short SESSION = 738;
    private static final String AC_NAME = "pfSense.localdomain";
    private static final long AC_COOKIE = 32098554083868671L;
    private static final String SERVICE_NAME = "*";
    private static final String PADI = "pppoed/padi.bin";
    private static final String PADO = "pppoed/pado.bin";
    private static final String PADR = "pppoed/padr.bin";
    private static final String PADS = "pppoed/pads.bin";
    private static final String PADT = "pppoed/padt.bin";

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(PPPoED.deserializer());
    }

    @Test
    public void testTruncatedPacket() throws Exception {
        byte[] byteHeader = ByteBuffer.allocate(6).put((byte)17).put((byte)9).putShort((short)0).putShort((short)0).array();
        PacketTestUtils.testDeserializeTruncated(PPPoED.deserializer(), byteHeader);
    }

    @Test
    public void testDeserializePadi() throws Exception {
        byte[] data = Resources.toByteArray((URL)PPPoEDTest.class.getResource(PADI));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        PPPoED pppoed = (PPPoED)eth.getPayload();
        this.assertPPPoEDHeader(pppoed, (byte)9);
        Assert.assertEquals((long)0L, (long)pppoed.getSessionId());
        Assert.assertEquals((long)0L, (long)pppoed.getTags().size());
    }

    @Test
    public void testDeserializePado() throws Exception {
        byte[] data = Resources.toByteArray((URL)PPPoEDTest.class.getResource(PADO));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        PPPoED pppoed = (PPPoED)eth.getPayload();
        this.assertPPPoEDHeader(pppoed, (byte)7);
        Assert.assertEquals((long)0L, (long)pppoed.getSessionId());
        Assert.assertEquals((long)3L, (long)pppoed.getTags().size());
        PPPoEDTag acName = pppoed.getTag((short)258);
        Assert.assertArrayEquals((byte[])AC_NAME.getBytes(), (byte[])acName.value);
        PPPoEDTag serviceName = pppoed.getTag((short)257);
        Assert.assertArrayEquals((byte[])SERVICE_NAME.getBytes(), (byte[])serviceName.value);
        PPPoEDTag acCookie = pppoed.getTag((short)260);
        Assert.assertEquals((long)32098554083868671L, (long)ByteBuffer.wrap(acCookie.value).getLong());
    }

    @Test
    public void testDeserializePadr() throws Exception {
        byte[] data = Resources.toByteArray((URL)PPPoEDTest.class.getResource(PADR));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        PPPoED pppoed = (PPPoED)eth.getPayload();
        this.assertPPPoEDHeader(pppoed, (byte)25);
        Assert.assertEquals((long)0L, (long)pppoed.getSessionId());
        Assert.assertEquals((long)1L, (long)pppoed.getTags().size());
        PPPoEDTag acCookie = pppoed.getTag((short)260);
        Assert.assertEquals((long)32098554083868671L, (long)ByteBuffer.wrap(acCookie.value).getLong());
    }

    @Test
    public void testDeserializePads() throws Exception {
        byte[] data = Resources.toByteArray((URL)PPPoEDTest.class.getResource(PADS));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        PPPoED pppoed = (PPPoED)eth.getPayload();
        this.assertPPPoEDHeader(pppoed, (byte)101);
        Assert.assertEquals((long)738L, (long)pppoed.getSessionId());
        Assert.assertEquals((long)2L, (long)pppoed.getTags().size());
        PPPoEDTag acName = pppoed.getTag((short)258);
        Assert.assertArrayEquals((byte[])AC_NAME.getBytes(), (byte[])acName.value);
        PPPoEDTag acCookie = pppoed.getTag((short)260);
        Assert.assertEquals((long)32098554083868671L, (long)ByteBuffer.wrap(acCookie.value).getLong());
    }

    @Test
    public void testDeserializePadt() throws Exception {
        byte[] data = Resources.toByteArray((URL)PPPoEDTest.class.getResource(PADT));
        Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(data, 0, data.length);
        PPPoED pppoed = (PPPoED)eth.getPayload();
        this.assertPPPoEDHeader(pppoed, (byte)-89);
        Assert.assertEquals((long)738L, (long)pppoed.getSessionId());
        Assert.assertEquals((long)1L, (long)pppoed.getTags().size());
        PPPoEDTag acCookie = pppoed.getTag((short)260);
        Assert.assertEquals((long)32098554083868671L, (long)ByteBuffer.wrap(acCookie.value).getLong());
    }

    private void assertPPPoEDHeader(PPPoED pppoed, byte code) {
        Assert.assertNotNull((Object)pppoed);
        Assert.assertEquals((long)1L, (long)pppoed.getVersion());
        Assert.assertEquals((long)1L, (long)pppoed.getType());
        Assert.assertEquals((long)code, (long)pppoed.getCode());
    }
}

