/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.packet.IPPrecedence;

public enum DscpClass {
    BE(0),
    AF11(10),
    AF12(12),
    AF13(14),
    AF21(18),
    AF22(20),
    AF23(22),
    AF31(26),
    AF32(28),
    AF33(30),
    AF41(34),
    AF42(36),
    AF43(38),
    CS1(8),
    CS2(16),
    CS3(24),
    CS4(32),
    CS5(40),
    CS6(48),
    CS7(56),
    EF(46);

    private static final short IP_PREC_MASK = 56;
    private static final short IP_PREC_RSHIFT = 3;
    private static final short DROP_PREC_MASK = 6;
    private static final short DROP_PREC_RSHIFT = 1;
    private short value;

    private DscpClass(short value) {
        this.value = value;
    }

    public static DscpClass fromShort(short value) {
        for (DscpClass b : DscpClass.values()) {
            if (value != b.value) continue;
            return b;
        }
        throw new IllegalArgumentException("DSCP class " + value + " is not valid");
    }

    public short getValue() {
        return this.value;
    }

    public IPPrecedence getIPPrecedence() {
        return IPPrecedence.fromShort((short)((this.value & 0x38) >> 3));
    }

    public short getDropPrecedence() {
        return (short)((this.value & 6) >> 1);
    }
}

