/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.net.URL;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.lacp.Lacp;
import org.onlab.packet.lacp.LacpBaseTlvTest;
import org.onlab.packet.lacp.LacpCollectorTlvTest;
import org.onlab.packet.lacp.LacpTerminatorTlvTest;
import org.onlab.packet.lacp.LacpTlv;

public class LacpTest {
    private static final String PACKET_DUMP = "lacp.bin";
    private static final byte LACP_VERSION = 1;
    private static final Map<Byte, LacpTlv> LACP_TLV = Maps.newHashMap();
    private static final Lacp LACP = new Lacp();
    private byte[] data;

    @Before
    public void setUp() throws Exception {
        this.data = Resources.toByteArray((URL)LacpBaseTlvTest.class.getResource(PACKET_DUMP));
    }

    @Test
    public void deserializer() throws Exception {
        Lacp lacp = (Lacp)Lacp.deserializer().deserialize(this.data, 0, this.data.length);
        Assert.assertEquals((long)1L, (long)lacp.getLacpVersion());
        Assert.assertEquals(LACP_TLV, (Object)lacp.getTlv());
    }

    @Test
    public void serialize() {
        Assert.assertArrayEquals((byte[])this.data, (byte[])LACP.serialize());
    }

    static {
        LACP_TLV.put((byte)1, (LacpTlv)LacpBaseTlvTest.BASE_TLV);
        LACP_TLV.put((byte)2, (LacpTlv)LacpBaseTlvTest.BASE_TLV);
        LACP_TLV.put((byte)3, (LacpTlv)LacpCollectorTlvTest.COLLECTOR_TLV);
        LACP_TLV.put((byte)0, (LacpTlv)LacpTerminatorTlvTest.TERMINATOR_TLV);
        LACP.setLacpVersion((byte)1).setTlv(LACP_TLV);
    }
}

