/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.net.InetAddresses;
import com.google.common.testing.EqualsTester;
import java.net.InetAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;

public class Ip4AddressTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutable(Ip4Address.class);
    }

    @Test
    public void testAddressVersion() {
        Assert.assertThat((Object)Ip4Address.VERSION, (Matcher)Matchers.is((Object)IpAddress.Version.INET));
    }

    @Test
    public void testAddrByteLength() {
        Assert.assertThat((Object)4, (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testAddrBitLength() {
        Assert.assertThat((Object)32, (Matcher)Matchers.is((Object)32));
    }

    @Test
    public void testVersion() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET));
    }

    @Test
    public void testAddressToOctetsIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{0, 0, 0, 0};
        ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
        value = new byte[]{-1, -1, -1, -1};
        ipAddress = Ip4Address.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toOctets(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testToInt() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toInt(), (Matcher)Matchers.is((Object)16909060));
        ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toInt(), (Matcher)Matchers.is((Object)0));
        ipAddress = Ip4Address.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toInt(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void testValueOfForIntegerIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((int)16909060);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = Ip4Address.valueOf((int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = Ip4Address.valueOf((int)-1);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfByteArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        Ip4Address ipAddress = Ip4Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        value = new byte[]{0, 0, 0, 0};
        ipAddress = Ip4Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        value = new byte[]{-1, -1, -1, -1};
        ipAddress = Ip4Address.valueOf((byte[])value);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv4() {
        byte[] value = null;
        Ip4Address ipAddress = Ip4Address.valueOf(value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3};
        Ip4Address ipAddress = Ip4Address.valueOf((byte[])value);
    }

    @Test
    public void testValueOfByteArrayOffsetIPv4() {
        byte[] value = new byte[]{11, 22, 33, 1, 2, 3, 4, 44, 55};
        Ip4Address ipAddress = Ip4Address.valueOf((byte[])value, (int)3);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        value = new byte[]{11, 22, 0, 0, 0, 0, 33};
        ipAddress = Ip4Address.valueOf((byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        value = new byte[]{11, 22, -1, -1, -1, -1, 33};
        ipAddress = Ip4Address.valueOf((byte[])value, (int)2);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfArrayInvalidOffsetIPv4() {
        byte[] value = new byte[]{11, 22, 33, 1, 2, 3, 4, 44, 55};
        Ip4Address ipAddress = Ip4Address.valueOf((byte[])value, (int)6);
    }

    @Test
    public void testValueOfInetAddressIPv4() {
        InetAddress inetAddress = InetAddresses.forString((String)"1.2.3.4");
        Ip4Address ipAddress = Ip4Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        inetAddress = InetAddresses.forString((String)"0.0.0.0");
        ipAddress = Ip4Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        inetAddress = InetAddresses.forString((String)"255.255.255.255");
        ipAddress = Ip4Address.valueOf((InetAddress)inetAddress);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test
    public void testValueOfStringIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = Ip4Address.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        Ip4Address ipAddress = Ip4Address.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        Ip4Address ipAddress = Ip4Address.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpAddress";
        Ip4Address ipAddress = Ip4Address.valueOf((String)fromString);
    }

    @Test
    public void testMakeMaskPrefixIPv4() {
        Ip4Address ipAddress = Ip4Address.makeMaskPrefix((int)25);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.128"));
        ipAddress = Ip4Address.makeMaskPrefix((int)0);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = Ip4Address.makeMaskPrefix((int)32);
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskPrefixIPv4() {
        Ip4Address ipAddress = Ip4Address.makeMaskPrefix((int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskPrefixIPv4() {
        Ip4Address ipAddress = Ip4Address.makeMaskPrefix((int)33);
    }

    @Test
    public void testMakeMaskedAddressIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.5");
        Ip4Address ipAddressMasked = Ip4Address.makeMaskedAddress((Ip4Address)ipAddress, (int)24);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1.2.3.0"));
        ipAddressMasked = Ip4Address.makeMaskedAddress((Ip4Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddressMasked = Ip4Address.makeMaskedAddress((Ip4Address)ipAddress, (int)32);
        Assert.assertThat((Object)ipAddressMasked.toString(), (Matcher)Matchers.is((Object)"1.2.3.5"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeNegativeMaskedAddressIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.5");
        Ip4Address ipAddressMasked = Ip4Address.makeMaskedAddress((Ip4Address)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMakeTooLongMaskedAddressIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.5");
        Ip4Address ipAddressMasked = Ip4Address.makeMaskedAddress((Ip4Address)ipAddress, (int)33);
    }

    @Test
    public void testComparisonIPv4() {
        Ip4Address addr1 = Ip4Address.valueOf((String)"1.2.3.4");
        Ip4Address addr2 = Ip4Address.valueOf((String)"1.2.3.4");
        Ip4Address addr3 = Ip4Address.valueOf((String)"1.2.3.3");
        Ip4Address addr4 = Ip4Address.valueOf((String)"1.2.3.5");
        Assert.assertTrue((addr1.compareTo((IpAddress)addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr4) < 0 ? 1 : 0) != 0);
        addr1 = Ip4Address.valueOf((String)"255.2.3.4");
        addr2 = Ip4Address.valueOf((String)"255.2.3.4");
        addr3 = Ip4Address.valueOf((String)"255.2.3.3");
        addr4 = Ip4Address.valueOf((String)"255.2.3.5");
        Assert.assertTrue((addr1.compareTo((IpAddress)addr2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((addr1.compareTo((IpAddress)addr4) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualityIPv4() {
        new EqualsTester().addEqualityGroup(new Object[]{Ip4Address.valueOf((String)"1.2.3.4"), Ip4Address.valueOf((String)"1.2.3.4")}).addEqualityGroup(new Object[]{Ip4Address.valueOf((String)"1.2.3.5"), Ip4Address.valueOf((String)"1.2.3.5")}).addEqualityGroup(new Object[]{Ip4Address.valueOf((String)"0.0.0.0"), Ip4Address.valueOf((String)"0.0.0.0")}).addEqualityGroup(new Object[]{Ip4Address.valueOf((String)"255.255.255.255"), Ip4Address.valueOf((String)"255.255.255.255")}).testEquals();
    }

    @Test
    public void testToStringIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"0.0.0.0"));
        ipAddress = Ip4Address.valueOf((String)"255.255.255.255");
        Assert.assertThat((Object)ipAddress.toString(), (Matcher)Matchers.is((Object)"255.255.255.255"));
    }
}

