/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.bmp;

import com.google.common.testing.EqualsTester;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.bmp.BmpPeer;

public class BmpPeerTest {
    private Deserializer<BmpPeer> deserializer;
    private byte type = 0;
    private byte flags = 0;
    private byte[] peerDistinguisher = new byte[8];
    private InetAddress peerAddress;
    private int peerAs = 60300;
    private int peerBgpId = 65323;
    private int seconds = 1024;
    private int microseconds = 0;
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = BmpPeer.deserializer();
        this.peerAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        ByteBuffer bb = ByteBuffer.allocate(42);
        bb.put(this.type);
        bb.put(this.flags);
        bb.put(this.peerDistinguisher);
        bb.put(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 1});
        bb.putInt(this.peerAs);
        bb.putInt(this.peerBgpId);
        bb.putInt(this.seconds);
        bb.putInt(this.microseconds);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.headerBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        BmpPeer bmpPeer = (BmpPeer)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        Assert.assertEquals((long)this.type, (long)bmpPeer.getType());
        Assert.assertEquals((long)this.flags, (long)bmpPeer.getFlag());
        Assert.assertEquals((long)this.peerDistinguisher.length, (long)bmpPeer.getPeerDistinguisher().length);
        Assert.assertEquals((Object)this.peerAddress.getHostAddress(), (Object)bmpPeer.getIntAddress().getHostAddress());
        Assert.assertEquals((long)this.peerAs, (long)bmpPeer.getPeerAs());
        Assert.assertEquals((long)this.peerBgpId, (long)bmpPeer.getPeerBgpId());
        Assert.assertEquals((long)this.seconds, (long)bmpPeer.getSeconds());
        Assert.assertEquals((long)this.microseconds, (long)bmpPeer.getMicroseconds());
    }

    @Test
    public void testToStringBmp() throws Exception {
        BmpPeer bmpPeer = (BmpPeer)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        String str = bmpPeer.toString();
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("flags=" + this.flags)));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("type=" + this.type)));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("peerDistinguisher=" + Arrays.toString(this.peerDistinguisher))));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("peerAddress=" + this.peerAddress.getHostAddress())));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("peerAs=" + this.peerAs)));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("peerBgpId=" + this.peerBgpId)));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("seconds=" + this.seconds)));
        Assert.assertTrue((boolean)StringUtils.contains((String)str, (String)("microseconds=" + this.microseconds)));
    }

    @Test
    public void testEquality() throws Exception {
        BmpPeer bmpPeer = (BmpPeer)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        new EqualsTester().addEqualityGroup(new Object[]{bmpPeer}).testEquals();
    }
}

