/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.bmp;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.bmp.Bmp;

public class BmpTest {
    private Deserializer<Bmp> deserializer;
    private byte version = (byte)3;
    private int length = 6;
    private byte type = 1;
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = Bmp.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(6);
        bb.put(this.version);
        bb.putInt(this.length);
        bb.put(this.type);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.headerBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        Bmp bmp = (Bmp)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        Assert.assertEquals((long)this.version, (long)bmp.getVersion());
        Assert.assertEquals((long)this.type, (long)bmp.getType());
        Assert.assertEquals((long)this.length, (long)bmp.getLength());
    }

    @Test
    public void testToStringBmp() throws Exception {
        Bmp bmp = (Bmp)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        String str = bmp.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("version=" + this.version)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("type=" + this.type)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("length=" + this.length)));
    }

    @Test
    public void testEquality() throws Exception {
        Bmp bmp = (Bmp)this.deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        new EqualsTester().addEqualityGroup(new Object[]{bmp}).testEquals();
    }
}

