/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Objects;
import junit.framework.TestCase;
import org.junit.Test;
import org.onlab.util.Match;

public class MatchTest {
    @Test
    public void testMatches() {
        Match m1 = Match.any();
        TestCase.assertTrue((boolean)m1.matches(null));
        TestCase.assertTrue((boolean)m1.matches((Object)"foo"));
        TestCase.assertTrue((boolean)m1.matches((Object)"bar"));
        Match m2 = Match.ifNull();
        TestCase.assertTrue((boolean)m2.matches(null));
        TestCase.assertFalse((boolean)m2.matches((Object)"foo"));
        Match m3 = Match.ifValue((Object)"foo");
        TestCase.assertFalse((boolean)m3.matches(null));
        TestCase.assertFalse((boolean)m3.matches((Object)"bar"));
        TestCase.assertTrue((boolean)m3.matches((Object)"foo"));
        Match m4 = Match.ifValue((Object)new byte[8]);
        TestCase.assertTrue((boolean)m4.matches((Object)new byte[8]));
        TestCase.assertFalse((boolean)m4.matches((Object)new byte[7]));
    }

    @Test
    public void testEquals() {
        Match m1 = Match.any();
        Match m2 = Match.any();
        Match m3 = Match.ifNull();
        Match m4 = Match.ifValue((Object)"bar");
        TestCase.assertEquals((Object)m1, (Object)m2);
        TestCase.assertFalse((boolean)Objects.equal((Object)m1, (Object)m3));
        TestCase.assertFalse((boolean)Objects.equal((Object)m3, (Object)m4));
        Object o = new Object();
        TestCase.assertFalse((boolean)Objects.equal((Object)m1, (Object)o));
    }

    @Test
    public void testMap() {
        Match m1 = Match.ifNull();
        TestCase.assertEquals((Object)m1.map(s -> "bar"), (Object)Match.ifNull());
        Match m2 = Match.ifValue((Object)"foo");
        Match m3 = m2.map(s -> "bar");
        TestCase.assertTrue((boolean)m3.matches((Object)"bar"));
    }

    @Test
    public void testIfNotNull() {
        Match m = Match.ifNotNull();
        TestCase.assertFalse((boolean)m.matches(null));
        TestCase.assertTrue((boolean)m.matches((Object)"foo"));
    }

    @Test
    public void testIfNotValue() {
        Match m1 = Match.ifNotValue(null);
        Match m2 = Match.ifNotValue((Object)"foo");
        TestCase.assertFalse((boolean)m1.matches(null));
        TestCase.assertFalse((boolean)m2.matches((Object)"foo"));
    }

    @Test
    public void testToString() {
        Match m1 = Match.any();
        Match m2 = Match.any();
        Match m3 = Match.ifValue((Object)"foo");
        Match m4 = Match.ifValue((Object)"foo");
        Match m5 = Match.ifNotValue((Object)"foo");
        String note = "Results of toString() should be consistent -- ";
        TestCase.assertTrue((String)note, (boolean)m1.toString().equals(m2.toString()));
        TestCase.assertTrue((String)note, (boolean)m3.toString().equals(m4.toString()));
        TestCase.assertFalse((String)note, (boolean)m4.toString().equals(m5.toString()));
    }

    @Test
    public void testHashCode() {
        Match m1 = Match.ifValue((Object)"foo");
        Match m2 = Match.ifNotValue((Object)"foo");
        Match m3 = Match.ifValue((Object)"foo");
        Match m4 = Match.ifNotNull();
        Match m5 = Match.ifNull();
        TestCase.assertTrue((m1.hashCode() == m3.hashCode() ? 1 : 0) != 0);
        TestCase.assertFalse((m2.hashCode() == m1.hashCode() ? 1 : 0) != 0);
        TestCase.assertFalse((m4.hashCode() == m5.hashCode() ? 1 : 0) != 0);
    }
}

