/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.bmp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;

public class Bmp
extends BasePacket {
    public static final short DEFAULT_HEADER_LENGTH = 6;
    public static final int DEFAULT_PACKET_MINIMUM_LENGTH = 4;
    protected byte version;
    protected byte type;
    protected int length;

    public void setVersion(byte version) {
        this.version = version;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getType() {
        return this.type;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[6];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.version);
        bb.putInt(this.length);
        bb.put(this.type);
        return data;
    }

    public static Deserializer<Bmp> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 6);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            Bmp bmp = new Bmp();
            bmp.version = bb.get();
            bmp.length = bb.getInt();
            bmp.type = bb.get();
            return bmp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", (int)this.version).add("type", (int)this.type).add("length", this.length).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version, this.type, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Bmp)) {
            return false;
        }
        Bmp other = (Bmp)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.length == other.length;
    }
}

