/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.bmp;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpPeer
extends BasePacket {
    public static final short PEER_HEADER_MINIMUM_LENGTH = 42;
    public static final short PEER_DISTINGUISHER = 8;
    public static final short IPV4_ADDRSZ = 4;
    public static final short IPV6_ADDRSZ = 16;
    protected byte type;
    protected byte flags;
    protected byte[] peerDistinguisher;
    protected InetAddress peerAddress;
    protected int peerAs;
    protected int peerBgpId;
    protected int seconds;
    protected int microseconds;
    private static Logger log = LoggerFactory.getLogger(BmpPeer.class);

    public byte getType() {
        return this.type;
    }

    public byte getFlag() {
        return this.flags;
    }

    public byte[] getPeerDistinguisher() {
        return this.peerDistinguisher;
    }

    public InetAddress getIntAddress() {
        return this.peerAddress;
    }

    public int getPeerAs() {
        return this.peerAs;
    }

    public int getPeerBgpId() {
        return this.peerBgpId;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[42];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.type);
        bb.put(this.flags);
        bb.put(this.peerDistinguisher);
        bb.put(this.peerAddress.getAddress());
        bb.putInt(this.peerAs);
        bb.putInt(this.peerBgpId);
        bb.putInt(this.seconds);
        bb.putInt(this.microseconds);
        return data;
    }

    public static Deserializer<BmpPeer> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 42);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            BmpPeer bmpPeer = new BmpPeer();
            bmpPeer.type = bb.get();
            bmpPeer.flags = bb.get();
            bmpPeer.peerDistinguisher = new byte[8];
            bb.get(bmpPeer.peerDistinguisher, 0, 8);
            if ((bmpPeer.flags & 0x80) != 0) {
                bmpPeer.peerAddress = BmpPeer.toInetAddress(16, bb);
            } else {
                bb.position(bb.position() + 12);
                bmpPeer.peerAddress = BmpPeer.toInetAddress(4, bb);
            }
            bmpPeer.peerAs = bb.getInt();
            bmpPeer.peerBgpId = bb.getInt();
            bmpPeer.seconds = bb.getInt();
            bmpPeer.microseconds = bb.getInt();
            return bmpPeer;
        };
    }

    private static InetAddress toInetAddress(int length, ByteBuffer bb) {
        byte[] address = new byte[length];
        bb.get(address, 0, length);
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            log.error("InetAddress conversion failed");
        }
        return ipAddress;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("flags", (int)this.flags).add("type", (int)this.type).add("peerDistinguisher", (Object)Arrays.toString(this.peerDistinguisher)).add("peerAddress", (Object)this.peerAddress.getHostAddress()).add("peerAs", this.peerAs).add("peerBgpId", this.peerBgpId).add("seconds", this.seconds).add("microseconds", this.microseconds).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.flags, this.type, this.peerAddress, Arrays.hashCode(this.peerDistinguisher), this.peerAs, this.peerBgpId, this.seconds, this.microseconds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BmpPeer)) {
            return false;
        }
        BmpPeer other = (BmpPeer)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (!Arrays.equals(this.peerDistinguisher, other.peerDistinguisher)) {
            return false;
        }
        if (this.peerAddress != other.peerAddress) {
            return false;
        }
        if (this.peerAs != other.peerAs) {
            return false;
        }
        if (this.peerBgpId != other.peerBgpId) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        return this.microseconds == other.microseconds;
    }
}

