/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.onlab.packet.VlanId;

public class CircuitId {
    private static final String SEPARATOR = ":";
    private static final String CIRCUIT_ID_FORMAT = "%s:%s";
    private String connectPoint;
    private VlanId vlanId;

    public CircuitId(String connectPoint, VlanId vlanId) {
        this.connectPoint = connectPoint;
        this.vlanId = vlanId;
    }

    public byte[] serialize() {
        return String.format(CIRCUIT_ID_FORMAT, this.connectPoint, this.vlanId.toString()).getBytes(StandardCharsets.US_ASCII);
    }

    public static CircuitId deserialize(byte[] circuitId) {
        String cIdString = new String(circuitId, StandardCharsets.US_ASCII);
        ArrayList splittedCircuitId = Lists.newArrayList((Object[])cIdString.split(SEPARATOR));
        Preconditions.checkArgument((splittedCircuitId.size() > 1 ? 1 : 0) != 0, (Object)"Illegal circuit id.");
        String vlanId = (String)splittedCircuitId.remove(splittedCircuitId.size() - 1);
        String connectPoint = String.join((CharSequence)SEPARATOR, splittedCircuitId);
        int idx = connectPoint.lastIndexOf("/");
        Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0, (Object)"Connect point not specified, Connect point must be in \"deviceUri/portNumber\" format");
        String cp = connectPoint.substring(idx + 1);
        Preconditions.checkArgument((!cp.isEmpty() ? 1 : 0) != 0, (Object)"Connect point separator specified, but no port number included, connect point must be in \"deviceUri/portNumber\" format");
        return new CircuitId(connectPoint, VlanId.vlanId(vlanId));
    }

    public String connectPoint() {
        return this.connectPoint;
    }

    public VlanId vlanId() {
        return this.vlanId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CircuitId)) {
            return false;
        }
        CircuitId that = (CircuitId)obj;
        return Objects.equals(this.connectPoint, that.connectPoint) && Objects.equals(this.vlanId, that.vlanId);
    }

    public int hashCode() {
        return Objects.hash(this.connectPoint, this.vlanId);
    }
}

