/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.StateMachine;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.event.Event;
import net.kuujo.copycat.event.EventContext;
import net.kuujo.copycat.event.EventHandlerRegistry;
import net.kuujo.copycat.event.EventHandlers;
import net.kuujo.copycat.event.Events;
import net.kuujo.copycat.internal.event.DefaultEvents;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.spi.protocol.Protocol;

public class Copycat {
    protected final StateContext state;
    protected final Cluster<?> cluster;
    protected final CopycatConfig config;
    protected final Events events;

    public <M extends Member> Copycat(StateMachine stateMachine, Log log, Cluster<M> cluster, Protocol<M> protocol) {
        this(stateMachine, log, cluster, protocol, new CopycatConfig());
    }

    public <M extends Member> Copycat(StateMachine stateMachine, Log log, Cluster<M> cluster, Protocol<M> protocol, CopycatConfig config) {
        this(new StateContext(stateMachine, log, cluster, protocol, config), cluster, config);
    }

    private Copycat(StateContext state, Cluster<?> cluster, CopycatConfig config) {
        this.state = state;
        this.cluster = cluster;
        this.config = config;
        this.events = new DefaultEvents(state.events());
    }

    public CopycatConfig config() {
        return this.config;
    }

    public <M extends Member> Cluster<M> cluster() {
        return this.cluster;
    }

    public Events on() {
        return this.events;
    }

    public <T extends Event> EventContext<T> on(Class<T> event) {
        return this.events.event(Assert.isNotNull(event, "Event cannot be null"));
    }

    public EventHandlers events() {
        return this.state.events();
    }

    public <T extends Event> EventHandlerRegistry<T> event(Class<T> event) {
        return this.state.events().event(Assert.isNotNull(event, "Event cannot be null"));
    }

    public CopycatState state() {
        return this.state.state();
    }

    public String leader() {
        return this.state.currentLeader();
    }

    public boolean isLeader() {
        return this.state.isLeader();
    }

    public CompletableFuture<Void> start() {
        return this.state.start();
    }

    public CompletableFuture<Void> stop() {
        return this.state.stop();
    }

    public <R> CompletableFuture<R> submit(String operation, Object ... args) {
        return this.state.submit(Assert.isNotNull(operation, "operation cannot be null"), args);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

