/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.internal.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.spi.CorrelationStrategy;
import net.kuujo.copycat.spi.QuorumStrategy;
import net.kuujo.copycat.spi.TimerStrategy;

public class CopycatConfig {
    public static final String ELECTION_TIMEOUT = "copycat.election.timeout";
    public static final String HEARTBEAT_INTERVAL = "copycat.heartbeat.interval";
    public static final String COMMAND_QUORUM = "copycat.command.quorum";
    public static final String COMMAND_QUORUM_SIZE = "copycat.command.quorum.size";
    public static final String COMMAND_QUORUM_STRATEGY = "copycat.command.quorum.strategy";
    public static final String COMMAND_CONSISTENT_EXECUTION = "copycat.command.consistent_execution";
    public static final String QUERY_QUORUM = "copycat.query.quorum";
    public static final String QUERY_QUORUM_SIZE = "copycat.query.quorum.size";
    public static final String QUERY_QUORUM_STRATEGY = "copycat.query.quorum.strategy";
    public static final String QUERY_CONSISTENT_EXECUTION = "copycat.query.consistent_execution";
    public static final String MAX_LOG_SIZE = "copycat.log.max_size";
    public static final String CORRELATION_STRATEGY = "copycat.correlation.strategy";
    public static final String TIMER_STRATEGY = "copycat.timer.strategy";
    private final Map<String, PropertyWrapper<?>> processors = new HashMap<String, PropertyWrapper<?>>(){
        {
            this.put(CopycatConfig.ELECTION_TIMEOUT, new PropertyWrapper(null, Long::valueOf, CopycatConfig.this::setElectionTimeout));
            this.put(CopycatConfig.HEARTBEAT_INTERVAL, new PropertyWrapper(null, Long::valueOf, CopycatConfig.this::setHeartbeatInterval));
            this.put(CopycatConfig.COMMAND_QUORUM, new PropertyWrapper(null, Boolean::parseBoolean, CopycatConfig.this::setRequireCommandQuorum));
            this.put(CopycatConfig.COMMAND_QUORUM_SIZE, new PropertyWrapper(null, Integer::valueOf, CopycatConfig.this::setCommandQuorumSize));
            this.put(CopycatConfig.COMMAND_QUORUM_STRATEGY, new PropertyWrapper(null, new ClassLoaderProcessor(), CopycatConfig.this::setCommandQuorumStrategy));
            this.put(CopycatConfig.COMMAND_CONSISTENT_EXECUTION, new PropertyWrapper(null, Boolean::parseBoolean, CopycatConfig.this::setConsistentCommandExecution));
            this.put(CopycatConfig.QUERY_QUORUM, new PropertyWrapper(null, Boolean::parseBoolean, CopycatConfig.this::setRequireQueryQuorum));
            this.put(CopycatConfig.QUERY_QUORUM_SIZE, new PropertyWrapper(null, Integer::valueOf, CopycatConfig.this::setQueryQuorumSize));
            this.put(CopycatConfig.QUERY_QUORUM_STRATEGY, new PropertyWrapper(null, new ClassLoaderProcessor(), CopycatConfig.this::setQueryQuorumStrategy));
            this.put(CopycatConfig.QUERY_CONSISTENT_EXECUTION, new PropertyWrapper(null, Boolean::parseBoolean, CopycatConfig.this::setConsistentQueryExecution));
            this.put(CopycatConfig.MAX_LOG_SIZE, new PropertyWrapper(null, Long::valueOf, CopycatConfig.this::setElectionTimeout));
            this.put(CopycatConfig.CORRELATION_STRATEGY, new PropertyWrapper(null, new ClassLoaderProcessor(), CopycatConfig.this::setCorrelationStrategy));
            this.put(CopycatConfig.TIMER_STRATEGY, new PropertyWrapper(null, new ClassLoaderProcessor(), CopycatConfig.this::setTimerStrategy));
        }
    };
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("config-timer-%s");
    private static final QuorumStrategy<?> DEFAULT_QUORUM_STRATEGY = cluster -> (int)Math.floor(cluster.members().size() / 2) + 1;
    private static final CorrelationStrategy<?> DEFAULT_CORRELATION_STRATEGY = () -> UUID.randomUUID().toString();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private final TimerStrategy DEFAULT_TIMER_STRATEGY = (task, delay, unit) -> this.scheduler.schedule(task, delay, unit);
    private long electionTimeout = 2000L;
    private long heartbeatInterval = 500L;
    private boolean requireCommandQuorum = true;
    private int commandQuorumSize = -1;
    private QuorumStrategy commandQuorumStrategy = DEFAULT_QUORUM_STRATEGY;
    private boolean consistentCommandExecution = true;
    private boolean requireQueryQuorum = true;
    private int queryQuorumSize = -1;
    private QuorumStrategy queryQuorumStrategy = DEFAULT_QUORUM_STRATEGY;
    private boolean consistentQueryExecution = true;
    private int maxLogSize = 0x2000000;
    private CorrelationStrategy<?> correlationStrategy = DEFAULT_CORRELATION_STRATEGY;
    private TimerStrategy timerStrategy = this.DEFAULT_TIMER_STRATEGY;

    public CopycatConfig() {
    }

    public CopycatConfig(Properties properties) {
        for (Map.Entry<String, PropertyWrapper<?>> entry : this.processors.entrySet()) {
            String value = properties.getProperty(entry.getKey());
            if (value == null) continue;
            PropertyWrapper<?> property = entry.getValue();
            if (((PropertyWrapper)property).validator != null && !((PropertyWrapper)property).validator.test(value)) {
                throw new CopycatException("Invalid property value for " + entry.getKey(), new Object[0]);
            }
            ((PropertyWrapper)property).setter.accept(((PropertyWrapper)property).processor.apply(value));
        }
    }

    public void setElectionTimeout(long timeout) {
        this.electionTimeout = Assert.arg(timeout, timeout > 0L, "Election timeout must be positive", new Object[0]);
    }

    public long getElectionTimeout() {
        return this.electionTimeout;
    }

    public CopycatConfig withElectionTimeout(long timeout) {
        this.electionTimeout = Assert.arg(timeout, timeout > 0L, "Election timeout must be positive", new Object[0]);
        return this;
    }

    public void setHeartbeatInterval(long interval) {
        this.heartbeatInterval = Assert.arg(interval, interval > 0L, "Heart beat interval must be positive", new Object[0]);
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public CopycatConfig withHeartbeatInterval(long interval) {
        this.heartbeatInterval = Assert.arg(interval, interval > 0L, "Heart beat interval must be positive", new Object[0]);
        return this;
    }

    public void setRequireCommandQuorum(boolean require) {
        this.requireCommandQuorum = require;
    }

    public boolean isRequireCommandQuorum() {
        return this.requireCommandQuorum;
    }

    public CopycatConfig withRequireCommandQuorum(boolean require) {
        this.requireCommandQuorum = require;
        return this;
    }

    public void setCommandQuorumSize(int quorumSize) {
        this.commandQuorumSize = Assert.arg(quorumSize, quorumSize > -1, "Quorum size must be -1 or greater", new Object[0]);
        this.commandQuorumStrategy = config -> this.commandQuorumSize;
    }

    public int getCommandQuorumSize() {
        return this.commandQuorumSize;
    }

    public CopycatConfig withCommandQuorumSize(int quorumSize) {
        this.commandQuorumSize = Assert.arg(quorumSize, quorumSize > -1, "Quorum size must be -1 or greater", new Object[0]);
        this.commandQuorumStrategy = config -> this.commandQuorumSize;
        return this;
    }

    public void setCommandQuorumStrategy(QuorumStrategy<?> strategy) {
        this.commandQuorumStrategy = Assert.isNotNull(strategy, "strategy");
    }

    public <C extends Cluster> QuorumStrategy<C> getCommandQuorumStrategy() {
        return this.commandQuorumStrategy;
    }

    public CopycatConfig withCommandQuorumStrategy(QuorumStrategy<?> strategy) {
        this.commandQuorumStrategy = Assert.isNotNull(strategy, "strategy");
        return this;
    }

    public void setConsistentCommandExecution(boolean consistent) {
        this.consistentCommandExecution = consistent;
        if (consistent) {
            this.setRequireCommandQuorum(true);
            this.commandQuorumSize = -1;
            this.commandQuorumStrategy = DEFAULT_QUORUM_STRATEGY;
        } else {
            this.setRequireCommandQuorum(false);
        }
    }

    public boolean isConsistentCommandExecution() {
        return this.consistentCommandExecution;
    }

    public CopycatConfig withConsistentCommandExecution(boolean consistent) {
        this.setConsistentCommandExecution(consistent);
        return this;
    }

    public void setRequireQueryQuorum(boolean require) {
        this.requireQueryQuorum = require;
    }

    public boolean isRequireQueryQuorum() {
        return this.requireQueryQuorum;
    }

    public CopycatConfig withRequireQueryQuorum(boolean require) {
        this.requireQueryQuorum = require;
        return this;
    }

    public void setQueryQuorumSize(int quorumSize) {
        this.queryQuorumSize = Assert.arg(quorumSize, quorumSize > -1, "Quorum size must be -1 or greater", new Object[0]);
        this.queryQuorumStrategy = config -> this.queryQuorumSize;
    }

    public int getQueryQuorumSize() {
        return this.queryQuorumSize;
    }

    public CopycatConfig withQueryQuorumSize(int quorumSize) {
        this.queryQuorumSize = Assert.arg(quorumSize, quorumSize > -1, "Quorum size must be -1 or greater", new Object[0]);
        this.queryQuorumStrategy = config -> this.queryQuorumSize;
        return this;
    }

    public void setQueryQuorumStrategy(QuorumStrategy<?> strategy) {
        this.queryQuorumStrategy = Assert.isNotNull(strategy, "strategy");
    }

    public <C extends Cluster> QuorumStrategy<C> getQueryQuorumStrategy() {
        return this.queryQuorumStrategy;
    }

    public CopycatConfig withQueryQuorumStrategn(QuorumStrategy<?> strategy) {
        this.queryQuorumStrategy = Assert.isNotNull(strategy, "strategy");
        return this;
    }

    public void setConsistentQueryExecution(boolean consistent) {
        this.consistentQueryExecution = consistent;
        if (consistent) {
            this.setRequireQueryQuorum(true);
            this.queryQuorumStrategy = DEFAULT_QUORUM_STRATEGY;
        } else {
            this.setRequireQueryQuorum(false);
        }
    }

    public boolean isConsistentQueryExecution() {
        return this.consistentQueryExecution;
    }

    public CopycatConfig withConsistentQueryExecution(boolean consistent) {
        this.setConsistentQueryExecution(consistent);
        return this;
    }

    public void setMaxLogSize(int maxSize) {
        this.maxLogSize = Assert.arg(maxSize, maxSize > 0, "Max log size must be positive", new Object[0]);
    }

    public int getMaxLogSize() {
        return this.maxLogSize;
    }

    public CopycatConfig withMaxLogSize(int maxSize) {
        this.maxLogSize = Assert.arg(maxSize, maxSize > 0, "Max log size must be positive", new Object[0]);
        return this;
    }

    public void setCorrelationStrategy(CorrelationStrategy<?> strategy) {
        this.correlationStrategy = Assert.isNotNull(strategy, "strategy");
    }

    public CorrelationStrategy<?> getCorrelationStrategy() {
        return this.correlationStrategy;
    }

    public CopycatConfig withCorrelationStrategy(CorrelationStrategy<?> strategy) {
        this.correlationStrategy = Assert.isNotNull(strategy, "strategy");
        return this;
    }

    public void setTimerStrategy(TimerStrategy strategy) {
        this.timerStrategy = Assert.isNotNull(strategy, "strategy");
    }

    public TimerStrategy getTimerStrategy() {
        return this.timerStrategy;
    }

    public CopycatConfig withTimerStrategy(TimerStrategy strategy) {
        this.timerStrategy = Assert.isNotNull(strategy, "strategy");
        return this;
    }

    public String toString() {
        String value = "CopycatConfig";
        value = value + "[\n";
        value = value + String.format("electionTimeout=%d", this.electionTimeout);
        value = value + ",\n";
        value = value + String.format("heartbeatInterval=%d", this.heartbeatInterval);
        value = value + ",\n";
        value = value + String.format("requireQueryQuorum=%s", this.requireQueryQuorum);
        value = value + ",\n";
        value = value + String.format("queryQuorumSize=%d", this.queryQuorumSize);
        value = value + ",\n";
        value = value + String.format("queryQuorumStrategy=%s", this.queryQuorumStrategy);
        value = value + ",\n";
        value = value + String.format("consistentQueryExecution=%s", this.consistentQueryExecution);
        value = value + ",\n";
        value = value + String.format("requireCommandQuorum=%s", this.requireCommandQuorum);
        value = value + ",\n";
        value = value + String.format("commandQuorumSize=%s", this.commandQuorumSize);
        value = value + ",\n";
        value = value + String.format("commandQuorumStrategy=%s", this.commandQuorumStrategy);
        value = value + ",\n";
        value = value + String.format("consistentCommandExecution=%s", this.consistentCommandExecution);
        value = value + ",\n";
        value = value + String.format("maxLogSize=%d", this.maxLogSize);
        value = value + ",\n";
        value = value + String.format("correlationStrategy=%s", this.correlationStrategy);
        value = value + ",\n";
        value = value + String.format("timerStrategy=%s", this.timerStrategy);
        value = value + "\n]";
        return value;
    }

    private static class PropertyWrapper<T> {
        private final Predicate<String> validator;
        private final Function<String, T> processor;
        private final Consumer setter;

        private PropertyWrapper(Predicate<String> validator, Function<String, T> processor, Consumer<T> setter) {
            this.validator = validator;
            this.processor = processor;
            this.setter = setter;
        }
    }

    private static class ClassLoaderProcessor<T>
    implements Function<String, T> {
        private ClassLoaderProcessor() {
        }

        @Override
        public T apply(String value) {
            try {
                return (T)Thread.currentThread().getContextClassLoader().loadClass(value).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

