/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.util.Copyable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster<M extends Member>
extends Observable
implements Observer,
Copyable<Cluster<M>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cluster.class);
    protected final ClusterConfig<M> config;
    private final M localMember;
    private final Set<M> remoteMembers;
    private final Map<String, M> members;

    public Cluster(ClusterConfig<M> config) {
        this.config = Assert.isNotNull(config, "config");
        this.localMember = config.getLocalMember();
        this.members = new HashMap<String, M>(config.getMembers().size());
        this.members.put(((Member)this.localMember).id(), this.localMember);
        this.remoteMembers = new HashSet<M>(config.getRemoteMembers().size());
        this.config.addObserver(this);
        this.clusterChanged(config);
    }

    @Override
    public Cluster<M> copy() {
        return new Cluster<M>(this.config.copy());
    }

    @Override
    public void update(Observable o, Object arg) {
        LOGGER.info("{} - Configuration change detected, updating membership", (Object)this);
        this.clusterChanged((ClusterConfig)o);
    }

    private void clusterChanged(ClusterConfig<M> config) {
        config.getMembers().forEach(member -> {
            if (!member.equals(this.localMember) && !this.members.containsKey(member.id())) {
                LOGGER.info("Added remote member {}", member);
                this.remoteMembers.add(member);
                this.members.put(member.id(), member);
            }
        });
        Iterator<M> iterator = this.remoteMembers.iterator();
        while (iterator.hasNext()) {
            Member member2 = (Member)iterator.next();
            boolean exists = false;
            for (Member m : config.getMembers()) {
                if (!m.equals(member2)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            LOGGER.info("Removed remote member {}", (Object)member2);
            iterator.remove();
            this.members.remove(member2.id());
        }
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    public ClusterConfig<M> config() {
        return this.config;
    }

    public M member(String id) {
        return (M)((Member)this.members.get(id));
    }

    public Set<M> members() {
        HashSet<M> members = new HashSet<M>(this.remoteMembers);
        members.add(this.localMember);
        return members;
    }

    public M localMember() {
        return this.localMember;
    }

    public M remoteMember(String id) {
        Member member = (Member)this.members.get(id);
        return (M)(member != this.localMember ? member : null);
    }

    public Set<M> remoteMembers() {
        return this.remoteMembers;
    }

    public boolean equals(Object object) {
        if (this.getClass().isInstance(object)) {
            Cluster config = (Cluster)object;
            return ((Member)config.localMember()).equals(this.localMember) && config.remoteMembers().equals(this.remoteMembers);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + ((Member)this.localMember).hashCode();
        hashCode = 37 * hashCode + this.remoteMembers.hashCode();
        return hashCode;
    }

    public String toString() {
        return String.format("%s[config=%s]", this.getClass().getSimpleName(), this.config);
    }
}

