/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.util.Copyable;

public class ClusterConfig<M extends Member>
extends Observable
implements Copyable<ClusterConfig<M>>,
Serializable {
    protected M localMember;
    protected Set<M> remoteMembers = new HashSet<M>(6);

    public ClusterConfig() {
    }

    public ClusterConfig(ClusterConfig<M> cluster) {
        this.localMember = Assert.isNotNull(cluster, (String)"cluster").localMember;
        this.remoteMembers = new HashSet<M>(cluster.remoteMembers);
    }

    public ClusterConfig(M localMember, M ... remoteMembers) {
        this(localMember, (Collection<M>)Arrays.asList(Assert.isNotNull(remoteMembers, "remoteMembers")));
    }

    public ClusterConfig(M localMember, Collection<M> remoteMembers) {
        this.localMember = (Member)Assert.isNotNull(localMember, "localMember");
        this.remoteMembers = new HashSet<M>(Assert.isNotNull(remoteMembers, "remoteMembers"));
    }

    private void notifyAndReset() {
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    @Override
    public ClusterConfig<M> copy() {
        return new ClusterConfig<M>(this.localMember, this.remoteMembers);
    }

    public ClusterConfig(Cluster<M> cluster) {
        this.localMember = Assert.isNotNull(cluster, "cluster").localMember();
        this.remoteMembers = cluster.remoteMembers();
    }

    public final void setLocalMember(M member) {
        this.localMember = (Member)Assert.isNotNull(member, "member");
    }

    public final M getLocalMember() {
        return this.localMember;
    }

    public final ClusterConfig<M> withLocalMember(M member) {
        this.localMember = (Member)Assert.isNotNull(member, "member");
        return this;
    }

    @SafeVarargs
    public final void setRemoteMembers(M ... members) {
        this.remoteMembers = new HashSet<M>(Arrays.asList(Assert.isNotNull(members, "members")));
        this.notifyAndReset();
    }

    public final void setRemoteMembers(Collection<M> members) {
        this.remoteMembers = new HashSet<M>(Assert.isNotNull(members, "members"));
        this.notifyAndReset();
    }

    public final ClusterConfig<M> addRemoteMember(M member) {
        this.remoteMembers.add(Assert.isNotNull(member, "member"));
        this.notifyAndReset();
        return this;
    }

    @SafeVarargs
    public final ClusterConfig<M> addRemoteMembers(M ... members) {
        this.remoteMembers.addAll(Arrays.asList(Assert.isNotNull(members, "members")));
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> addRemoteMembers(Collection<M> members) {
        this.remoteMembers.addAll(Assert.isNotNull(members, "members"));
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> addRemoteMembers(ClusterConfig<M> cluster) {
        Assert.isNotNull(cluster, "cluster");
        this.remoteMembers.addAll(cluster.remoteMembers);
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> removeRemoteMember(M member) {
        this.remoteMembers.remove(Assert.isNotNull(member, "member"));
        this.notifyAndReset();
        return this;
    }

    @SafeVarargs
    public final ClusterConfig<M> removeRemoteMembers(M ... members) {
        this.remoteMembers.removeAll(Arrays.asList(Assert.isNotNull(members, "members")));
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> removeRemoteMembers(Collection<M> members) {
        this.remoteMembers.removeAll(Assert.isNotNull(members, "members"));
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> removeRemoteMembers(ClusterConfig<M> cluster) {
        this.remoteMembers.removeAll(cluster.remoteMembers);
        this.notifyAndReset();
        return this;
    }

    public final Set<M> getRemoteMembers() {
        return this.remoteMembers;
    }

    @SafeVarargs
    public final ClusterConfig<M> withRemoteMembers(M ... members) {
        this.remoteMembers = new HashSet<M>(Arrays.asList(Assert.isNotNull(members, "members")));
        this.notifyAndReset();
        return this;
    }

    public final ClusterConfig<M> withRemoteMembers(Collection<M> members) {
        this.remoteMembers = new HashSet<M>(Assert.isNotNull(members, "members"));
        this.notifyAndReset();
        return this;
    }

    public final Set<M> getMembers() {
        HashSet<M> members = new HashSet<M>(this.remoteMembers);
        members.add(this.localMember);
        return members;
    }

    public boolean equals(Object object) {
        if (this.getClass().isInstance(object)) {
            ClusterConfig config = (ClusterConfig)object;
            return ((Member)config.getLocalMember()).equals(this.localMember) && config.getRemoteMembers().equals(this.remoteMembers);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + ((Member)this.localMember).hashCode();
        hashCode = 37 * hashCode + this.remoteMembers.hashCode();
        return hashCode;
    }

    public String toString() {
        return String.format("%s[localMember=%s, remoteMembers=%s]", this.getClass().getSimpleName(), this.localMember, this.remoteMembers);
    }
}

