/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;

public class LocalClusterConfig
extends ClusterConfig<Member> {
    public LocalClusterConfig() {
    }

    public LocalClusterConfig(ClusterConfig<Member> cluster) {
        super(cluster);
    }

    public LocalClusterConfig(Member localMember, Member ... remoteMembers) {
        this(localMember, (Collection<Member>)Arrays.asList(remoteMembers));
    }

    public LocalClusterConfig(Member localMember, Collection<Member> remoteMembers) {
        super(localMember, remoteMembers);
    }

    @Override
    public LocalClusterConfig copy() {
        return new LocalClusterConfig(this.localMember, this.remoteMembers);
    }

    @Override
    public void setLocalMember(String id) {
        super.setLocalMember(new Member(id));
    }

    public LocalClusterConfig withLocalMember(String id) {
        super.setLocalMember(new Member(id));
        return this;
    }

    public void setRemoteMembers(int numMembers) {
        ArrayList<Member> members = new ArrayList<Member>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            members.add(new Member(UUID.randomUUID().toString()));
        }
        super.setRemoteMembers(members);
    }

    public LocalClusterConfig withRemoteMembers(int numMembers) {
        this.setRemoteMembers(numMembers);
        return this;
    }

    public void setRemoteMembers(String ... ids) {
        super.setRemoteMembers(Arrays.asList(ids).stream().map(Member::new).collect(Collectors.toList()));
    }

    public LocalClusterConfig withRemoteMembers(String ... ids) {
        this.setRemoteMembers(ids);
        return this;
    }

    public LocalClusterConfig addRemoteMember(String id) {
        this.addRemoteMember(new Member(id));
        return this;
    }

    public LocalClusterConfig removeRemoteMember(String id) {
        this.removeRemoteMember(new Member(id));
        return this;
    }
}

