/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.TcpMemberConfig;

public class TcpMember
extends Member {
    private final String host;
    private final int port;

    public TcpMember(String host, int port) {
        super(String.format("%s:%s", host, port));
        this.host = host;
        this.port = port;
    }

    public TcpMember(TcpMemberConfig config) {
        super(config);
        this.host = config.getHost();
        this.port = config.getPort();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TcpMember) {
            TcpMember member = (TcpMember)object;
            return member.host.equals(this.host) && member.port == this.port;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 43;
        hashCode = 37 * hashCode + this.id().hashCode();
        hashCode = 37 * hashCode + this.host.hashCode();
        hashCode = 37 * hashCode + this.port;
        return hashCode;
    }

    @Override
    public String toString() {
        return String.format("%s[host=%s, port=%d]", this.getClass().getSimpleName(), this.host, this.port);
    }
}

