/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.copycat.Command;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.Query;
import net.kuujo.copycat.StateMachine;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.internal.util.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateMachineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineExecutor.class);
    private final StateMachine stateMachine;
    private final Map<String, Operation> operations = new HashMap<String, Operation>();

    public StateMachineExecutor(StateMachine stateMachine) {
        this.stateMachine = Assert.isNotNull(stateMachine, "stateMachine");
        this.init();
    }

    private void init() {
        for (Class<?> clazz = this.stateMachine.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                Command command = Reflection.findAnnotation(method, Command.class);
                if (command != null) {
                    this.addCommandMethod(method, command);
                    continue;
                }
                Query query = Reflection.findAnnotation(method, Query.class);
                if (query == null) continue;
                this.addQueryMethod(method, query);
            }
        }
    }

    private void addCommandMethod(Method method, Command command) {
        Operation operation;
        String name = command.name();
        if (name.equals("")) {
            name = method.getName();
        }
        if ((operation = this.operations.get(name)) == null) {
            operation = new Operation(this.stateMachine, false, new ArrayList(10));
            this.operations.put(name, operation);
        } else if (operation.isReadOnly()) {
            throw new IllegalStateException("Overloaded methods must be of the same type");
        }
        operation.methods.add(method);
    }

    private void addQueryMethod(Method method, Query query) {
        Operation operation;
        String name = query.name();
        if (name.equals("")) {
            name = method.getName();
        }
        if ((operation = this.operations.get(name)) == null) {
            operation = new Operation(this.stateMachine, true, new ArrayList(10));
            this.operations.put(name, operation);
        } else if (!operation.isReadOnly()) {
            throw new IllegalStateException("Overloaded methods must be of the same type");
        }
        operation.methods.add(method);
    }

    public StateMachine stateMachine() {
        return this.stateMachine;
    }

    public Operation getOperation(String name) {
        return this.operations.get(name);
    }

    public static class GenericCommand
    implements Annotation,
    Command {
        private final String name;

        public GenericCommand(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Command.class;
        }
    }

    public static class Operation {
        private final StateMachine stateMachine;
        private final boolean readOnly;
        private final List<Method> methods;

        private Operation(StateMachine stateMachine, boolean readOnly, List<Method> methods) {
            this.stateMachine = stateMachine;
            this.readOnly = readOnly;
            this.methods = methods;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Object apply(List<Object> args) {
            int size = args.size();
            block2: for (Method method : this.methods) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length != size) continue;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (!paramTypes[i].isAssignableFrom(args.get(i).getClass())) continue block2;
                }
                try {
                    LOGGER.debug("{} calling {} with arguments: {}", new Object[]{this.stateMachine, method.getName(), args});
                    return method.invoke((Object)this.stateMachine, args.toArray());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new CopycatException(e);
                }
            }
            throw new CopycatException("Invalid command", new Object[0]);
        }
    }
}

