/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.cluster.LocalNode;
import net.kuujo.copycat.internal.cluster.Node;
import net.kuujo.copycat.internal.cluster.RemoteNode;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.spi.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManager<M extends Member>
extends Observable
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterManager.class);
    private final Protocol<M> protocol;
    private final Cluster<M> cluster;
    private final LocalNode<M> localNode;
    private final Set<RemoteNode<M>> remoteNodes;
    private final Map<String, Node<M>> nodes;

    public ClusterManager(Cluster<M> cluster, Protocol<M> protocol) {
        this.cluster = cluster.copy();
        this.protocol = Assert.isNotNull(protocol, "protocol");
        this.localNode = new LocalNode<M>(this.cluster.localMember(), protocol);
        this.remoteNodes = new HashSet<RemoteNode<M>>(this.cluster.remoteMembers().size());
        this.nodes = new HashMap<String, Node<M>>(this.cluster.members().size());
        this.cluster.addObserver(this);
        this.clusterChanged(this.cluster);
    }

    @Override
    public void update(Observable o, Object arg) {
        LOGGER.debug("{} - Membership change detected, updating nodes", (Object)this);
        this.clusterChanged((Cluster)o);
    }

    private synchronized void clusterChanged(Cluster<M> cluster) {
        cluster.remoteMembers().forEach(member -> {
            if (!this.nodes.containsKey(member.id())) {
                RemoteNode<Member> node = new RemoteNode<Member>((Member)member, (Protocol<Member>)this.protocol);
                this.remoteNodes.add(node);
                this.nodes.put(member.id(), node);
            }
        });
        Iterator<RemoteNode<M>> iterator = this.remoteNodes.iterator();
        while (iterator.hasNext()) {
            RemoteNode<M> node = iterator.next();
            boolean exists = false;
            for (Member member2 : cluster.remoteMembers()) {
                if (!member2.equals(node.member())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            iterator.remove();
            this.nodes.remove(((Member)node.member()).id());
            node.client().close();
        }
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
    }

    public Cluster<M> cluster() {
        return this.cluster;
    }

    public <T extends Node<M>> T node(String id) {
        return (T)(((Member)this.localNode.member()).id().equals(id) ? this.localNode : this.nodes.get(id));
    }

    public Set<Node<M>> nodes() {
        HashSet<Node<M>> nodes = new HashSet<Node<M>>(this.remoteNodes);
        nodes.add(this.localNode);
        return nodes;
    }

    public LocalNode<M> localNode() {
        return this.localNode;
    }

    public RemoteNode<M> remoteNode(String id) {
        Node<M> node = this.nodes.get(id);
        return node != null && node instanceof RemoteNode ? (RemoteNode)node : null;
    }

    public Set<RemoteNode<M>> remoteNodes() {
        return this.remoteNodes;
    }

    public boolean equals(Object object) {
        if (object instanceof ClusterManager) {
            ClusterManager clusterManager = (ClusterManager)object;
            return clusterManager.localNode.equals(this.localNode) && clusterManager.remoteNodes.equals(this.remoteNodes);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 79;
        hashCode = 37 * hashCode + this.localNode.hashCode();
        hashCode = 37 * hashCode + this.remoteNodes.hashCode();
        return hashCode;
    }

    public String toString() {
        return String.format("ClusterManager[cluster=%s]", this.cluster);
    }
}

