/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.event;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.kuujo.copycat.event.Event;
import net.kuujo.copycat.event.EventContext;
import net.kuujo.copycat.event.EventHandler;
import net.kuujo.copycat.event.EventHandlerRegistry;
import net.kuujo.copycat.internal.util.concurrent.NamedThreadFactory;

public class DefaultEventContext<E extends Event>
implements EventContext<E>,
EventHandler<E> {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("event-handler-%s");
    private final Executor executor = Executors.newCachedThreadPool(THREAD_FACTORY);
    private HandlerHolder handler;

    public DefaultEventContext(EventHandlerRegistry<E> registry) {
        registry.registerHandler(this);
    }

    @Override
    public void handle(E event) {
        if (this.handler != null) {
            this.handler.run(event);
        }
    }

    @Override
    public EventContext<E> run(EventHandler<E> handler) {
        this.handler = new HandlerHolder(handler, false, false);
        return this;
    }

    @Override
    public EventContext<E> runAsync(EventHandler<E> handler) {
        this.handler = new HandlerHolder(handler, false, true);
        return this;
    }

    @Override
    public EventContext<E> runOnce(EventHandler<E> handler) {
        this.handler = new HandlerHolder(handler, true, false);
        return this;
    }

    @Override
    public EventContext<E> runOnceAsync(EventHandler<E> handler) {
        this.handler = new HandlerHolder(handler, true, true);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class HandlerHolder {
        private final EventHandler<E> handler;
        private final boolean once;
        private final boolean async;

        private HandlerHolder(EventHandler<E> handler, boolean once, boolean async) {
            this.handler = handler;
            this.once = once;
            this.async = async;
        }

        public void run(E event) {
            if (this.async) {
                DefaultEventContext.this.executor.execute(() -> this.handler.handle((Event)event));
            } else {
                this.handler.handle(event);
            }
            if (this.once) {
                DefaultEventContext.this.handler = null;
            }
        }
    }
}

