/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.event;

import java.util.HashSet;
import java.util.Set;
import net.kuujo.copycat.event.Event;
import net.kuujo.copycat.event.EventHandler;
import net.kuujo.copycat.event.EventHandlerRegistry;

public class DefaultEventHandlerRegistry<E extends Event>
implements EventHandlerRegistry<E>,
EventHandler<E> {
    private final Set<EventHandler<E>> handlers = new HashSet<EventHandler<E>>(10);

    @Override
    public EventHandlerRegistry<E> registerHandler(EventHandler<E> handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public EventHandlerRegistry<E> unregisterHandler(EventHandler<E> handler) {
        this.handlers.remove(handler);
        return this;
    }

    @Override
    public void handle(E event) {
        for (EventHandler<E> handler : this.handlers) {
            handler.handle(event);
        }
    }

    public String toString() {
        return String.format("%s[handlers=%s]", this.getClass().getSimpleName(), this.handlers);
    }
}

