/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.event;

import net.kuujo.copycat.event.Event;
import net.kuujo.copycat.event.EventContext;
import net.kuujo.copycat.event.EventHandlers;
import net.kuujo.copycat.event.Events;
import net.kuujo.copycat.event.LeaderElectEvent;
import net.kuujo.copycat.event.MembershipChangeEvent;
import net.kuujo.copycat.event.StartEvent;
import net.kuujo.copycat.event.StateChangeEvent;
import net.kuujo.copycat.event.StopEvent;
import net.kuujo.copycat.event.VoteCastEvent;
import net.kuujo.copycat.internal.event.DefaultEventContext;

public class DefaultEvents
implements Events {
    private final EventContext<StartEvent> start;
    private final EventContext<StopEvent> stop;
    private final EventContext<VoteCastEvent> voteCast;
    private final EventContext<LeaderElectEvent> leaderElect;
    private final EventContext<MembershipChangeEvent> membershipChange;
    private final EventContext<StateChangeEvent> stateChange;

    public DefaultEvents(EventHandlers registry) {
        this.start = new DefaultEventContext<StartEvent>(registry.start());
        this.stop = new DefaultEventContext<StopEvent>(registry.stop());
        this.voteCast = new DefaultEventContext<VoteCastEvent>(registry.voteCast());
        this.leaderElect = new DefaultEventContext<LeaderElectEvent>(registry.leaderElect());
        this.membershipChange = new DefaultEventContext<MembershipChangeEvent>(registry.membershipChange());
        this.stateChange = new DefaultEventContext<StateChangeEvent>(registry.stateChange());
    }

    public <E extends Event> EventContext<E> event(Class<E> event) {
        if (event == Events.START) {
            return this.start;
        }
        if (event == Events.STOP) {
            return this.stop;
        }
        if (event == Events.VOTE_CAST) {
            return this.voteCast;
        }
        if (event == Events.LEADER_ELECT) {
            return this.leaderElect;
        }
        if (event == Events.MEMBERSHIP_CHANGE) {
            return this.membershipChange;
        }
        if (event == Events.STATE_CHANGE) {
            return this.stateChange;
        }
        throw new IllegalArgumentException("Unsupported event type");
    }

    @Override
    public EventContext<StartEvent> start() {
        return this.start;
    }

    @Override
    public EventContext<StopEvent> stop() {
        return this.stop;
    }

    @Override
    public EventContext<VoteCastEvent> voteCast() {
        return this.voteCast;
    }

    @Override
    public EventContext<LeaderElectEvent> leaderElect() {
        return this.leaderElect;
    }

    @Override
    public EventContext<MembershipChangeEvent> membershipChange() {
        return this.membershipChange;
    }

    @Override
    public EventContext<StateChangeEvent> stateChange() {
        return this.stateChange;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

