/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.log;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.log.EntryType;

@EntryType(id=4, serializer=Serializer.class)
public class ConfigurationEntry
extends CopycatEntry {
    private ClusterConfig cluster;

    private ConfigurationEntry() {
    }

    public ConfigurationEntry(long term, ClusterConfig cluster) {
        super(term);
        this.cluster = cluster;
    }

    public <M extends Member> ClusterConfig<M> cluster() {
        return this.cluster;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigurationEntry) {
            ConfigurationEntry entry = (ConfigurationEntry)object;
            return this.term == entry.term && this.cluster.equals(entry.cluster);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + (int)(this.term ^ this.term >>> 32);
        hashCode = 37 * hashCode + this.cluster.hashCode();
        return hashCode;
    }

    @Override
    public String toString() {
        return String.format("ConfigurationEntry[term=%d, cluster=%s]", this.term(), this.cluster);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<ConfigurationEntry> {
        @Override
        public ConfigurationEntry read(Kryo kryo, Input input, Class<ConfigurationEntry> type) {
            ConfigurationEntry entry = new ConfigurationEntry();
            entry.term = input.readLong();
            entry.cluster = (ClusterConfig)kryo.readClassAndObject(input);
            return entry;
        }

        @Override
        public void write(Kryo kryo, Output output, ConfigurationEntry entry) {
            output.writeLong(entry.term);
            kryo.writeClassAndObject(output, entry.cluster);
        }
    }
}

