/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.log;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.log.EntryType;

@EntryType(id=3, serializer=Serializer.class)
public class OperationEntry
extends CopycatEntry {
    private String operation;
    private List<Object> args;

    private OperationEntry() {
    }

    public OperationEntry(long term, String operation, Object ... args) {
        this(term, operation, Arrays.asList(args));
    }

    public OperationEntry(long term, String operation, List<Object> args) {
        super(term);
        this.operation = operation;
        this.args = args;
    }

    public String operation() {
        return this.operation;
    }

    public List<Object> args() {
        return this.args;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OperationEntry) {
            OperationEntry entry = (OperationEntry)object;
            return this.term == entry.term && this.operation.equals(entry.operation) && this.args.equals(entry.args);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + (int)(this.term ^ this.term >>> 32);
        hashCode = 37 * hashCode + this.operation.hashCode();
        hashCode = 37 * hashCode + this.args.hashCode();
        return hashCode;
    }

    @Override
    public String toString() {
        return String.format("OperationEntry[term=%d, operation=%s, args=%s]", this.term, this.operation, this.args);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<OperationEntry> {
        @Override
        public OperationEntry read(Kryo kryo, Input input, Class<OperationEntry> type) {
            OperationEntry entry = new OperationEntry();
            entry.term = input.readLong();
            int commandLength = input.readInt();
            byte[] commandBytes = new byte[commandLength];
            input.readBytes(commandBytes);
            entry.operation = new String(commandBytes);
            entry.args = kryo.readObject(input, ArrayList.class);
            return entry;
        }

        @Override
        public void write(Kryo kryo, Output output, OperationEntry entry) {
            output.writeLong(entry.term);
            byte[] commandBytes = entry.operation.getBytes();
            output.writeInt(commandBytes.length);
            output.writeBytes(commandBytes);
            kryo.writeObject(output, entry.args);
        }
    }
}

