/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.log;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.log.EntryType;

@EntryType(id=5, serializer=Serializer.class)
public class SnapshotEntry
extends CopycatEntry {
    private ClusterConfig cluster;
    private byte[] data;

    private SnapshotEntry() {
    }

    public SnapshotEntry(long term, ClusterConfig cluster, byte[] data) {
        super(term);
        this.cluster = cluster;
        this.data = data;
    }

    public <M extends Member> ClusterConfig<M> cluster() {
        return this.cluster;
    }

    public byte[] data() {
        return this.data;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SnapshotEntry) {
            SnapshotEntry entry = (SnapshotEntry)object;
            return this.term == entry.term && this.cluster.equals(entry.cluster) && Arrays.equals(this.data, entry.data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + (int)(this.term ^ this.term >>> 32);
        hashCode = 37 * hashCode + this.cluster.hashCode();
        hashCode = 37 * hashCode + Arrays.hashCode(this.data);
        return hashCode;
    }

    @Override
    public String toString() {
        return String.format("SnapshotEntry[term=%d, config=%s, data=...]", this.term, this.cluster);
    }

    static /* synthetic */ byte[] access$202(SnapshotEntry x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<SnapshotEntry> {
        @Override
        public SnapshotEntry read(Kryo kryo, Input input, Class<SnapshotEntry> type) {
            SnapshotEntry entry = new SnapshotEntry();
            entry.term = input.readLong();
            entry.cluster = (ClusterConfig)kryo.readClassAndObject(input);
            int length = input.readInt();
            SnapshotEntry.access$202(entry, new byte[length]);
            input.readBytes(entry.data);
            return entry;
        }

        @Override
        public void write(Kryo kryo, Output output, SnapshotEntry entry) {
            output.writeLong(entry.term);
            kryo.writeClassAndObject(output, entry.cluster);
            output.writeInt(entry.data.length);
            output.writeBytes(entry.data);
        }
    }
}

