/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.cluster.ClusterManager;
import net.kuujo.copycat.internal.cluster.RemoteNode;
import net.kuujo.copycat.internal.replication.NodeReplicator;
import net.kuujo.copycat.internal.replication.Replicator;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.internal.util.Quorum;

public class ClusterReplicator
implements Replicator,
Observer {
    private final StateContext state;
    private final Map<String, NodeReplicator> replicaMap;
    private final List<NodeReplicator> replicas;
    private Integer readQuorum;
    private Integer writeQuorum;
    private int quorumIndex;
    private final TreeMap<Long, CompletableFuture<Long>> commitFutures = new TreeMap();

    public ClusterReplicator(StateContext state) {
        this.state = state;
        this.replicaMap = new HashMap<String, NodeReplicator>(state.cluster().members().size());
        this.replicas = new ArrayList<NodeReplicator>(state.cluster().members().size());
        this.init();
    }

    private void init() {
        this.recalculateQuorumSize();
        this.state.clusterManager().addObserver(this);
        this.clusterChanged(this.state.clusterManager());
    }

    private void recalculateQuorumSize() {
        this.readQuorum = this.state.config().getQueryQuorumSize();
        if (this.readQuorum < 1) {
            this.readQuorum = this.state.config().getQueryQuorumStrategy().calculateQuorumSize(this.state.clusterManager().cluster());
        }
        this.writeQuorum = this.state.config().getCommandQuorumSize();
        if (this.writeQuorum < 1) {
            this.writeQuorum = this.state.config().getCommandQuorumStrategy().calculateQuorumSize(this.state.clusterManager().cluster());
        }
        int clusterSize = this.replicas.size() + 1;
        int quorumSize = (int)Math.floor(clusterSize / 2) + 1;
        this.quorumIndex = clusterSize - quorumSize;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.clusterChanged((ClusterManager)o);
    }

    private synchronized void clusterChanged(ClusterManager<?> clusterManager) {
        clusterManager.remoteNodes().forEach(node -> {
            if (!this.replicaMap.containsKey(((Member)node.member()).id())) {
                NodeReplicator replica = new NodeReplicator((RemoteNode<?>)node, this.state);
                this.replicaMap.put(((Member)node.member()).id(), replica);
                this.replicas.add(replica);
                replica.open();
                this.recalculateQuorumSize();
            }
        });
        Iterator<NodeReplicator> iterator = this.replicas.iterator();
        while (iterator.hasNext()) {
            NodeReplicator replica = iterator.next();
            if (clusterManager.remoteNode(((Member)replica.node().member()).id()) != null) continue;
            replica.close();
            iterator.remove();
            this.replicaMap.remove(((Member)replica.node().member()).id());
        }
    }

    @Override
    public CompletableFuture<Long> replicate(long index) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        Quorum quorum = new Quorum(this.writeQuorum, succeeded -> {
            if (succeeded.booleanValue()) {
                future.complete(index);
            } else {
                future.completeExceptionally(new CopycatException("Failed to obtain quorum", new Object[0]));
            }
        }).countSelf();
        for (NodeReplicator replica : this.replicaMap.values()) {
            replica.replicate(index).whenComplete((resultIndex, error) -> {
                if (error == null) {
                    quorum.succeed();
                    this.checkCommits();
                } else {
                    quorum.fail();
                }
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<Long> replicateAll() {
        return this.commit(this.state.log().lastIndex());
    }

    @Override
    public CompletableFuture<Long> ping(long index) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        Quorum quorum = new Quorum(this.readQuorum, succeeded -> {
            if (succeeded.booleanValue()) {
                future.complete(index);
            } else {
                future.completeExceptionally(new CopycatException("Failed to obtain quorum", new Object[0]));
            }
        }).countSelf();
        for (NodeReplicator replica : this.replicaMap.values()) {
            replica.ping(index).whenComplete((resultIndex, error) -> {
                if (error == null) {
                    quorum.succeed();
                } else {
                    quorum.fail();
                }
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<Long> pingAll() {
        return this.ping(this.state.log().lastIndex());
    }

    @Override
    public CompletableFuture<Long> commit(long index) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.commitFutures.put(index, future);
        this.replicate(index).whenComplete((resultIndex, error) -> {
            if (error == null) {
                this.triggerCommitFutures((long)resultIndex);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Long> commitAll() {
        return this.commit(this.state.log().lastIndex());
    }

    private void checkCommits() {
        if (!this.replicas.isEmpty() && this.quorumIndex >= 0) {
            Collections.sort(this.replicas, (o1, o2) -> Long.compare(o1.index(), o2.index()));
            long commitIndex = this.replicas.get(this.quorumIndex).index();
            this.state.commitIndex(commitIndex);
            this.triggerCommitFutures(commitIndex);
        }
    }

    private synchronized void triggerCommitFutures(long index) {
        Map.Entry<Long, CompletableFuture<Long>> entry;
        Iterator<Map.Entry<Long, CompletableFuture<Long>>> iterator = this.commitFutures.entrySet().iterator();
        while (iterator.hasNext() && (entry = iterator.next()).getKey() <= index) {
            iterator.remove();
            entry.getValue().complete(entry.getKey());
        }
    }

    public String toString() {
        return String.format("ClusterReplicator[cluster=%s]", this.replicas);
    }
}

