/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.cluster.RemoteNode;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.internal.log.SnapshotEntry;
import net.kuujo.copycat.internal.state.FollowerController;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SyncRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeReplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeReplicator.class);
    private static final int BATCH_SIZE = 100;
    private final RemoteNode<?> node;
    private final StateContext state;
    private final Log log;
    private volatile long nextIndex;
    private volatile long matchIndex = 0L;
    private volatile long sendIndex;
    private volatile boolean open;
    private final TreeMap<Long, CompletableFuture<Long>> pingFutures = new TreeMap();
    private final Map<Long, CompletableFuture<Long>> replicateFutures = new ConcurrentHashMap<Long, CompletableFuture<Long>>(1024);

    public NodeReplicator(RemoteNode<?> node, StateContext state) {
        this.node = node;
        this.state = state;
        this.log = state.log();
        this.sendIndex = this.nextIndex = this.log.lastIndex() + 1L;
    }

    RemoteNode<?> node() {
        return this.node;
    }

    long index() {
        return this.matchIndex;
    }

    CompletableFuture<Void> open() {
        if (!this.open) {
            return this.node.client().connect().whenComplete((result, error) -> {
                if (error == null) {
                    this.open = true;
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    synchronized CompletableFuture<Long> ping(long index) {
        if (!this.open) {
            CompletableFuture<Long> future = new CompletableFuture<Long>();
            future.completeExceptionally(new CopycatException("Connection not open", new Object[0]));
            return future;
        }
        if (index > this.matchIndex) {
            return this.replicate(index);
        }
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        if (!this.pingFutures.isEmpty() && this.pingFutures.lastKey() >= index) {
            Map.Entry<Long, CompletableFuture<Long>> pendingEntry = this.pingFutures.lastEntry();
            LOGGER.trace("Pending ping future for {} exist, suppressing {}", (Object)pendingEntry.getKey(), (Object)index);
            return pendingEntry.getValue();
        }
        this.pingFutures.put(index, future);
        PingRequest request = new PingRequest(this.state.nextCorrelationId(), this.state.currentTerm(), ((Member)this.state.cluster().localMember()).id(), index, this.log.containsEntry(index) ? ((CopycatEntry)this.log.getEntry(index)).term() : 0L, this.state.commitIndex());
        LOGGER.debug("{} - Sent {} to {}", new Object[]{this.state.clusterManager().localNode(), request, this.node});
        this.node.client().ping(request).whenComplete((response, error) -> {
            if (error != null) {
                this.triggerPingFutures(index, (Throwable)error);
            } else {
                LOGGER.debug("{} - Received {} from {}", new Object[]{this.state.clusterManager().localNode(), response, this.node});
                if (response.status().equals((Object)Response.Status.OK)) {
                    if (response.term() > this.state.currentTerm()) {
                        this.state.currentTerm(response.term());
                        this.state.currentLeader(null);
                        this.state.transition(FollowerController.class);
                        this.triggerPingFutures(index, new CopycatException("Not the leader", new Object[0]));
                    } else if (!response.succeeded()) {
                        this.triggerPingFutures(index, new ProtocolException("Replica not in sync", new Object[0]));
                    } else {
                        this.triggerPingFutures(index);
                    }
                } else {
                    this.triggerPingFutures(index, response.error());
                }
            }
        });
        return future;
    }

    CompletableFuture<Long> replicate(long index) {
        if (!this.open) {
            CompletableFuture<Long> future = new CompletableFuture<Long>();
            future.completeExceptionally(new CopycatException("Connection not open", new Object[0]));
            return future;
        }
        if (index <= this.matchIndex) {
            return CompletableFuture.completedFuture(index);
        }
        CompletableFuture<Long> future = this.replicateFutures.get(index);
        if (future != null) {
            LOGGER.trace("Pending replicate Future exist for {}", (Object)index);
            return future;
        }
        future = new CompletableFuture();
        CompletableFuture<Long> existingFuture = this.replicateFutures.putIfAbsent(index, future);
        if (existingFuture != null) {
            return existingFuture;
        }
        if (index >= this.sendIndex) {
            this.replicate();
        }
        return future;
    }

    private synchronized void replicate() {
        long prevIndex = this.sendIndex - 1L;
        CopycatEntry prevEntry = (CopycatEntry)this.log.getEntry(prevIndex);
        ArrayList<CopycatEntry> entries = new ArrayList<CopycatEntry>(100);
        long firstIndex = Math.max(this.sendIndex, this.log.firstIndex());
        long lastIndex = Math.min(this.sendIndex + 100L - 1L, this.log.lastIndex());
        for (long i = firstIndex; i <= lastIndex; ++i) {
            CopycatEntry entry = (CopycatEntry)this.log.getEntry(i);
            if (entry instanceof SnapshotEntry) {
                if (entries.isEmpty()) {
                    this.doSync(prevIndex, prevEntry, Collections.singletonList(entry));
                } else {
                    this.doSync(prevIndex, prevEntry, entries);
                }
                return;
            }
            entries.add(entry);
        }
        if (!entries.isEmpty()) {
            this.doSync(prevIndex, prevEntry, entries);
        }
    }

    private void doSync(long prevIndex, CopycatEntry prevEntry, List<CopycatEntry> entries) {
        long commitIndex = this.state.commitIndex();
        SyncRequest request = new SyncRequest(this.state.nextCorrelationId(), this.state.currentTerm(), ((Member)this.state.clusterManager().localNode().member()).id(), prevIndex, prevEntry != null ? prevEntry.term() : 0L, entries, commitIndex);
        this.sendIndex = Math.max(this.sendIndex, prevIndex + (long)entries.size() + 1L);
        LOGGER.debug("{} - Sent {} to {}", new Object[]{this.state.clusterManager().localNode(), request, this.node});
        this.node.client().sync(request).whenComplete((response, error) -> {
            if (error != null) {
                LOGGER.warn("{} - Sync ID:{} to {} failed: {}", new Object[]{this.state.clusterManager().localNode(), request.id(), this.node, error.getMessage()});
                LOGGER.debug("{} - Failure details {} ", new Object[]{this.state.clusterManager().localNode(), request, error});
                this.triggerReplicateFutures(prevIndex + 1L, prevIndex + (long)entries.size(), (Throwable)error);
                this.sendIndex = Math.max(this.nextIndex, Math.min(this.sendIndex, prevIndex + 1L));
            } else {
                LOGGER.debug("{} - Received {} from {}", new Object[]{this.state.clusterManager().localNode(), response, this.node});
                if (response.status().equals((Object)Response.Status.OK)) {
                    if (response.succeeded()) {
                        if (!entries.isEmpty()) {
                            this.nextIndex = Math.max(this.nextIndex, prevIndex + (long)entries.size() + 1L);
                            this.matchIndex = Math.max(this.matchIndex, prevIndex + (long)entries.size());
                            this.triggerReplicateFutures(prevIndex + 1L, prevIndex + (long)entries.size());
                            this.replicate();
                        }
                    } else if (response.term() > this.state.currentTerm()) {
                        this.triggerReplicateFutures(prevIndex, prevIndex, new CopycatException("Not the leader", new Object[0]));
                        this.state.transition(FollowerController.class);
                    } else {
                        this.nextIndex = this.sendIndex = Math.max(response.lastLogIndex(), this.log.firstIndex());
                        this.replicate();
                    }
                } else {
                    LOGGER.warn("{} - Received sync ID:{} failure from {}: {}", new Object[]{this.state.clusterManager().localNode(), request.id(), this.node, error.getMessage()});
                    LOGGER.debug("{} - Failure details {} ", new Object[]{this.state.clusterManager().localNode(), request, error});
                    this.triggerReplicateFutures(prevIndex + 1L, prevIndex + (long)entries.size(), response.error());
                    this.sendIndex = Math.max(this.nextIndex, Math.min(this.sendIndex, prevIndex + 1L));
                }
            }
        });
    }

    private synchronized void triggerPingFutures(long index) {
        NavigableMap<Long, CompletableFuture<Long>> matchFutures = this.pingFutures.headMap(index, true);
        for (Map.Entry entry : matchFutures.entrySet()) {
            ((CompletableFuture)entry.getValue()).complete(index);
        }
        matchFutures.clear();
    }

    private synchronized void triggerPingFutures(long index, Throwable t) {
        CompletableFuture<Long> future = this.pingFutures.remove(index);
        if (future != null) {
            future.completeExceptionally(t);
        }
    }

    private void triggerReplicateFutures(long startIndex, long endIndex, Throwable t) {
        if (endIndex >= startIndex) {
            for (long i = startIndex; i <= endIndex; ++i) {
                CompletableFuture<Long> future = this.replicateFutures.remove(i);
                if (future == null) continue;
                future.completeExceptionally(t);
            }
        }
    }

    private void triggerReplicateFutures(long startIndex, long endIndex) {
        if (endIndex >= startIndex) {
            for (long i = startIndex; i <= endIndex; ++i) {
                CompletableFuture<Long> future = this.replicateFutures.remove(i);
                if (future == null) continue;
                future.complete(i);
            }
        }
    }

    CompletableFuture<Void> close() {
        return this.node.client().close().whenComplete((result, error) -> {
            this.open = false;
        });
    }

    public boolean equals(Object object) {
        return object instanceof NodeReplicator && ((NodeReplicator)object).node.equals(this.node);
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode = 37 * hashCode + this.node.hashCode();
        return hashCode;
    }

    public String toString() {
        return this.node.toString();
    }
}

