/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.internal.cluster.RemoteNode;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.internal.state.FollowerController;
import net.kuujo.copycat.internal.state.LeaderController;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.internal.state.StateController;
import net.kuujo.copycat.internal.util.Quorum;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.spi.protocol.ProtocolClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateController
extends StateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CandidateController.class);
    private Quorum quorum;
    private ScheduledFuture<Void> currentTimer;

    @Override
    CopycatState state() {
        return CopycatState.CANDIDATE;
    }

    @Override
    Logger logger() {
        return LOGGER;
    }

    @Override
    void init(StateContext context) {
        super.init(context);
        LOGGER.info("{} - Starting election", context.clusterManager().localNode());
        this.resetTimer();
    }

    private synchronized void resetTimer() {
        if (this.currentTimer != null) {
            this.currentTimer.cancel(true);
        }
        this.context.currentTerm(this.context.currentTerm() + 1L);
        long delay = this.context.config().getElectionTimeout() - this.context.config().getElectionTimeout() / 4L + Math.round(Math.random() * (double)(this.context.config().getElectionTimeout() / 2L));
        this.currentTimer = this.context.config().getTimerStrategy().schedule(() -> {
            LOGGER.info("{} - Election timed out", this.context.clusterManager().localNode());
            if (this.quorum != null) {
                this.quorum.cancel();
                this.quorum = null;
            }
            this.resetTimer();
            LOGGER.info("{} - Restarted election", this.context.clusterManager().localNode());
        }, delay, TimeUnit.MILLISECONDS);
        AtomicBoolean complete = new AtomicBoolean();
        Quorum quorum = new Quorum((int)Math.floor(this.context.clusterManager().nodes().size() / 2) + 1, elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.context.transition(LeaderController.class);
            } else {
                this.context.transition(FollowerController.class);
            }
        }).countSelf();
        long lastIndex = this.context.log().lastIndex();
        CopycatEntry lastEntry = (CopycatEntry)this.context.log().getEntry(lastIndex);
        LOGGER.info("{} - Polling members {}", this.context.clusterManager().localNode(), this.context.clusterManager().cluster().remoteMembers());
        long lastTerm = lastEntry != null ? lastEntry.term() : 0L;
        for (RemoteNode node : this.context.clusterManager().remoteNodes()) {
            ProtocolClient client = node.client();
            client.connect().whenComplete((result1, error1) -> {
                if (error1 != null) {
                    quorum.fail();
                } else {
                    LOGGER.debug("{} - Polling {}", this.context.clusterManager().localNode(), node.member());
                    client.poll(new PollRequest(this.context.nextCorrelationId(), this.context.currentTerm(), ((Member)this.context.clusterManager().localNode().member()).id(), lastIndex, lastTerm)).whenComplete((result2, error2) -> {
                        client.close();
                        if (!complete.get()) {
                            if (error2 != null) {
                                LOGGER.warn("{} - Polling {} failed with Exception: {}", new Object[]{this.context.clusterManager().localNode(), node.member(), error2.getMessage()});
                                LOGGER.debug("{} - Polling {} failed with Exception", new Object[]{this.context.clusterManager().localNode(), node.member(), error2});
                                quorum.fail();
                            } else if (!result2.voteGranted()) {
                                LOGGER.info("{} - Received rejected vote from {}", this.context.clusterManager().localNode(), node.member());
                                quorum.fail();
                            } else if (result2.term() != this.context.currentTerm()) {
                                LOGGER.info("{} - Received successful vote for a different term from {}", this.context.clusterManager().localNode(), node.member());
                                quorum.fail();
                            } else {
                                LOGGER.info("{} - Received successful vote from {}", this.context.clusterManager().localNode(), node.member());
                                quorum.succeed();
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public CompletableFuture<PingResponse> ping(PingRequest request) {
        if (request.term() >= this.context.currentTerm()) {
            this.context.currentTerm(request.term());
            this.context.currentLeader(null);
            this.context.lastVotedFor(null);
            this.context.transition(FollowerController.class);
        }
        return super.ping(request);
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        if (request.term() > this.context.currentTerm()) {
            this.context.currentTerm(request.term());
            this.context.currentLeader(null);
            this.context.lastVotedFor(null);
            this.context.transition(FollowerController.class);
        }
        if (!request.candidate().equals(((Member)this.context.clusterManager().localNode().member()).id())) {
            return CompletableFuture.completedFuture(this.logResponse(new PollResponse(this.logRequest(request).id(), this.context.currentTerm(), false)));
        }
        return super.poll(request);
    }

    @Override
    synchronized void destroy() {
        if (this.currentTimer != null) {
            LOGGER.debug("{} - Cancelling election", this.context.clusterManager().localNode());
            this.currentTimer.cancel(true);
        }
        if (this.quorum != null) {
            this.quorum.cancel();
            this.quorum = null;
        }
    }

    @Override
    public String toString() {
        return String.format("CandidateController[context=%s]", this.context);
    }
}

