/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.state;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.internal.state.CandidateController;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.internal.state.StateController;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowerController
extends StateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FollowerController.class);
    private ScheduledFuture<Void> currentTimer;
    private boolean shutdown = true;

    @Override
    CopycatState state() {
        return CopycatState.FOLLOWER;
    }

    @Override
    Logger logger() {
        return LOGGER;
    }

    @Override
    public synchronized void init(StateContext context) {
        this.shutdown = false;
        super.init(context);
        LOGGER.debug("{} - Starting heartbeat timer", context.clusterManager().localNode());
        this.resetTimer();
    }

    private synchronized void resetTimer() {
        if (!this.shutdown) {
            if (this.currentTimer != null) {
                LOGGER.debug("{} - Reset heartbeat timeout", this.context.clusterManager().localNode());
                this.currentTimer.cancel(true);
            }
            this.context.lastVotedFor(null);
            long delay = this.context.config().getElectionTimeout() - this.context.config().getElectionTimeout() / 4L + Math.round(Math.random() * (double)(this.context.config().getElectionTimeout() / 2L));
            this.currentTimer = this.context.config().getTimerStrategy().schedule(() -> {
                this.currentTimer = null;
                if (this.context.lastVotedFor() == null) {
                    LOGGER.info("{} - Heartbeat timed out", this.context.clusterManager().localNode());
                    this.context.transition(CandidateController.class);
                } else {
                    this.resetTimer();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public CompletableFuture<PingResponse> ping(PingRequest request) {
        this.resetTimer();
        return super.ping(request);
    }

    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        this.resetTimer();
        return super.sync(request);
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        return super.poll(request);
    }

    @Override
    public synchronized void destroy() {
        if (this.currentTimer != null) {
            LOGGER.debug("{} - Cancelling heartbeat timer", this.context.clusterManager().localNode());
            this.currentTimer.cancel(true);
        }
        this.shutdown = true;
    }

    @Override
    public String toString() {
        return String.format("FollowerController[context=%s]", this.context);
    }
}

