/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.state;

import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.internal.state.StateController;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoneController
extends StateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoneController.class);

    @Override
    CopycatState state() {
        return CopycatState.NONE;
    }

    @Override
    Logger logger() {
        return LOGGER;
    }

    @Override
    public void init(StateContext context) {
        context.currentLeader(null);
    }

    @Override
    public CompletableFuture<PingResponse> ping(PingRequest request) {
        return CompletableFuture.completedFuture(this.logResponse(new PingResponse(this.logRequest(request).id(), "Replica is not alive")));
    }

    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        return CompletableFuture.completedFuture(this.logResponse(new SyncResponse(this.logRequest(request).id(), "Replica is not alive")));
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        return CompletableFuture.completedFuture(this.logResponse(new PollResponse(this.logRequest(request).id(), "Replica is not alive")));
    }

    @Override
    public CompletableFuture<SubmitResponse> submit(SubmitRequest request) {
        return CompletableFuture.completedFuture(this.logResponse(new SubmitResponse(this.logRequest(request).id(), "Replica is not alive")));
    }

    @Override
    void destroy() {
    }

    @Override
    public String toString() {
        return "None[context=null]";
    }
}

