/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.state;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.StateMachine;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.event.LeaderElectEvent;
import net.kuujo.copycat.event.StartEvent;
import net.kuujo.copycat.event.StateChangeEvent;
import net.kuujo.copycat.event.StopEvent;
import net.kuujo.copycat.internal.StateMachineExecutor;
import net.kuujo.copycat.internal.cluster.ClusterManager;
import net.kuujo.copycat.internal.cluster.Node;
import net.kuujo.copycat.internal.event.DefaultEventHandlerRegistry;
import net.kuujo.copycat.internal.event.DefaultEventHandlers;
import net.kuujo.copycat.internal.state.FollowerController;
import net.kuujo.copycat.internal.state.NoneController;
import net.kuujo.copycat.internal.state.StateController;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.spi.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateContext.class);
    private final Cluster cluster;
    private final ClusterManager clusterManager;
    private final StateMachineExecutor stateMachineExecutor;
    private final Log log;
    private final CopycatConfig config;
    private final DefaultEventHandlers events = new DefaultEventHandlers();
    private volatile StateController currentState;
    private volatile String currentLeader;
    private volatile long currentTerm;
    private volatile String lastVotedFor;
    private volatile long commitIndex = 0L;
    private volatile long lastApplied = 0L;

    public <M extends Member> StateContext(StateMachine stateMachine, Log log, Cluster<M> cluster, Protocol<M> protocol, CopycatConfig config) {
        this.stateMachineExecutor = new StateMachineExecutor(stateMachine);
        this.log = Assert.isNotNull(log, "log");
        this.cluster = Assert.isNotNull(cluster, "cluster");
        this.config = Assert.isNotNull(config, "config");
        this.clusterManager = new ClusterManager<M>(cluster, protocol);
    }

    public StateMachineExecutor stateMachineExecutor() {
        return this.stateMachineExecutor;
    }

    public CopycatConfig config() {
        return this.config;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public ClusterManager clusterManager() {
        return this.clusterManager;
    }

    public Log log() {
        return this.log;
    }

    public DefaultEventHandlers events() {
        return this.events;
    }

    public CopycatState state() {
        return this.currentState.state();
    }

    public CompletableFuture<Void> start() {
        LOGGER.info("{} Starting context", this.clusterManager.localNode());
        this.transition(NoneController.class);
        this.checkConfiguration();
        return this.clusterManager.localNode().server().listen().whenComplete((result, error) -> {
            try {
                this.log.open();
            }
            catch (Exception e) {
                throw new CopycatException(e);
            }
            this.transition(FollowerController.class);
            ((DefaultEventHandlerRegistry)this.events.start()).handle(new StartEvent());
        });
    }

    private void checkConfiguration() {
        if (this.clusterManager.remoteNodes().isEmpty()) {
            LOGGER.warn("{} - No remote nodes in the cluster!", this.clusterManager.localNode());
        }
        if (!this.config.isRequireQueryQuorum()) {
            LOGGER.warn("{} - Read quorums are disabled! This can cause stale reads!", this.clusterManager.localNode());
        }
        if (!this.config.isRequireCommandQuorum()) {
            LOGGER.warn("{} - Write quorums are disabled! This can cause data loss!", this.clusterManager.localNode());
        }
        if (this.config.getElectionTimeout() < this.config.getHeartbeatInterval()) {
            LOGGER.error("{} - Election timeout is greater than heartbeat interval!", this.clusterManager.localNode());
        }
    }

    public CompletableFuture<Void> stop() {
        LOGGER.info("{} - Stopping context", this.clusterManager.localNode());
        return this.clusterManager.localNode().server().close().whenComplete((result, error) -> {
            try {
                this.log.close();
            }
            catch (Exception e) {
                throw new CopycatException(e);
            }
            this.transition(NoneController.class);
            ((DefaultEventHandlerRegistry)this.events.stop()).handle(new StopEvent());
        });
    }

    public synchronized void transition(Class<? extends StateController> type) {
        Assert.isNotNull(type, "type");
        if (this.currentState == null && type == null || this.currentState != null && type != null && type.isAssignableFrom(this.currentState.getClass())) {
            return;
        }
        StateController oldState = this.currentState;
        try {
            this.currentState = type.newInstance();
            LOGGER.info("{} - Transitioning to {}", this.clusterManager.localNode(), (Object)this.currentState.state());
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("{} - Failed transitioning to {}", new Object[]{this.clusterManager.localNode(), this.currentState.state(), e});
        }
        try {
            if (oldState != null) {
                oldState.destroy();
                this.currentState.init(this);
            } else {
                this.currentState.init(this);
            }
        }
        catch (Exception e) {
            LOGGER.error("{} - Failed during init", this.clusterManager.localNode(), (Object)e);
            throw e;
        }
        LOGGER.info("{} - Transitioned to {} [term={}]", new Object[]{this.clusterManager.localNode(), this.currentState.state(), this.currentTerm});
        ((DefaultEventHandlerRegistry)this.events.stateChange()).handle(new StateChangeEvent(this.currentState.state()));
    }

    public String currentLeader() {
        return this.currentLeader;
    }

    public StateContext currentLeader(String leader) {
        if (this.currentLeader == null || !this.currentLeader.equals(leader)) {
            LOGGER.debug("{} - currentLeader: {}", this.clusterManager.localNode(), (Object)leader);
        }
        if (this.currentLeader == null && leader != null) {
            this.currentLeader = leader;
            ((DefaultEventHandlerRegistry)this.events.leaderElect()).handle(new LeaderElectEvent(this.currentTerm, (Member)((Node)this.clusterManager.node(this.currentLeader)).member()));
        } else if (this.currentLeader != null && leader != null && !this.currentLeader.equals(leader)) {
            this.currentLeader = leader;
            ((DefaultEventHandlerRegistry)this.events.leaderElect()).handle(new LeaderElectEvent(this.currentTerm, (Member)((Node)this.clusterManager.node(this.currentLeader)).member()));
        } else {
            this.currentLeader = leader;
        }
        return this;
    }

    public boolean isLeader() {
        return this.currentLeader != null && this.currentLeader.equals(((Member)this.clusterManager.localNode().member()).id());
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    public StateContext currentTerm(long term) {
        if (term > this.currentTerm) {
            this.currentTerm = term;
            LOGGER.debug("{} - currentTerm: {}", this.clusterManager.localNode(), (Object)term);
            this.lastVotedFor = null;
        }
        return this;
    }

    public String lastVotedFor() {
        return this.lastVotedFor;
    }

    public StateContext lastVotedFor(String candidate) {
        if (this.lastVotedFor == null || !this.lastVotedFor.equals(candidate)) {
            LOGGER.debug("{} - lastVotedFor: {}", this.clusterManager.localNode(), (Object)candidate);
        }
        this.lastVotedFor = candidate;
        return this;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public StateContext commitIndex(long index) {
        LOGGER.debug("{} - commitIndex: {}", this.clusterManager.localNode(), (Object)index);
        this.commitIndex = Math.max(this.commitIndex, index);
        return this;
    }

    public long lastApplied() {
        return this.lastApplied;
    }

    public StateContext lastApplied(long index) {
        LOGGER.debug("{} - lastApplied: {}", this.clusterManager.localNode(), (Object)index);
        this.lastApplied = index;
        return this;
    }

    public Object nextCorrelationId() {
        return this.config.getCorrelationStrategy().nextCorrelationId();
    }

    public <R> CompletableFuture<R> submit(String operation, Object ... args) {
        CompletableFuture future = new CompletableFuture();
        if (this.currentState == null) {
            future.completeExceptionally(new CopycatException("Invalid copycat state", new Object[0]));
            return future;
        }
        this.currentState.submit(new SubmitRequest(this.nextCorrelationId(), operation, Arrays.asList(args))).whenComplete((response, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else if (response.status().equals((Object)Response.Status.OK)) {
                future.complete(response.result());
            } else {
                future.completeExceptionally(response.error());
            }
        });
        return future;
    }

    public String toString() {
        String value = "StateContext";
        value = value + "[\n";
        value = value + String.format("memberId=%s", ((Member)this.clusterManager.localNode().member()).id());
        value = value + ",\n";
        value = value + String.format("state=%s", new Object[]{this.currentState.state()});
        value = value + ",\n";
        value = value + String.format("term=%d", this.currentTerm);
        value = value + ",\n";
        value = value + String.format("leader=%s", this.currentLeader);
        value = value + ",\n";
        value = value + String.format("lastVotedFor=%s", this.lastVotedFor);
        value = value + ",\n";
        value = value + String.format("commitIndex=%s", this.commitIndex);
        value = value + ",\n";
        value = value + String.format("lastApplied=%s", this.lastApplied);
        value = value + "\n]";
        return value;
    }
}

