/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.state;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.CopycatException;
import net.kuujo.copycat.CopycatState;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.event.MembershipChangeEvent;
import net.kuujo.copycat.event.VoteCastEvent;
import net.kuujo.copycat.internal.StateMachineExecutor;
import net.kuujo.copycat.internal.cluster.Node;
import net.kuujo.copycat.internal.cluster.RemoteNode;
import net.kuujo.copycat.internal.event.DefaultEventHandlerRegistry;
import net.kuujo.copycat.internal.log.ConfigurationEntry;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.internal.log.OperationEntry;
import net.kuujo.copycat.internal.log.SnapshotEntry;
import net.kuujo.copycat.internal.state.FollowerController;
import net.kuujo.copycat.internal.state.StateContext;
import net.kuujo.copycat.log.Entry;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.Request;
import net.kuujo.copycat.protocol.RequestHandler;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import org.slf4j.Logger;

abstract class StateController
implements RequestHandler {
    protected StateContext context;
    private final AtomicBoolean transition = new AtomicBoolean();

    StateController() {
    }

    abstract CopycatState state();

    abstract Logger logger();

    protected final <R extends Request> R logRequest(R request) {
        this.logger().trace("{} - Received {}", this.context.clusterManager().localNode(), request);
        return request;
    }

    protected final <R extends Response> R logResponse(R response) {
        this.logger().trace("{} - Sent {}", this.context.clusterManager().localNode(), response);
        return response;
    }

    void init(StateContext context) {
        this.context = context;
        context.clusterManager().localNode().server().requestHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PingResponse> ping(PingRequest request) {
        StateContext stateContext = this.context;
        synchronized (stateContext) {
            StateController stateController = this;
            synchronized (stateController) {
                CompletableFuture<PingResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handlePing(this.logRequest(request))));
                if (this.transition.get()) {
                    this.context.transition(FollowerController.class);
                }
                return future;
            }
        }
    }

    private synchronized PingResponse handlePing(PingRequest request) {
        if (request.term() > this.context.currentTerm() || request.term() == this.context.currentTerm() && this.context.currentLeader() == null) {
            this.context.currentTerm(request.term());
            this.context.currentLeader(request.leader());
            this.transition.set(true);
        }
        if (request.term() < this.context.currentTerm()) {
            this.logger().warn("{} - Rejected {}: ping request term is less than the current term ({})", new Object[]{this.context.clusterManager().localNode(), request, this.context.currentTerm()});
            return new PingResponse(request.id(), this.context.currentTerm(), false);
        }
        if (request.logIndex() > 0L && request.logTerm() > 0L) {
            return this.doCheckPingEntry(request);
        }
        return new PingResponse(request.id(), this.context.currentTerm(), true);
    }

    private synchronized PingResponse doCheckPingEntry(PingRequest request) {
        if (request.logIndex() > this.context.log().lastIndex()) {
            this.logger().warn("{} - Rejected {}: previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.clusterManager().localNode(), request, request.logIndex(), this.context.log().lastIndex()});
            return new PingResponse(request.id(), this.context.currentTerm(), false);
        }
        CopycatEntry entry = (CopycatEntry)this.context.log().getEntry(request.logIndex());
        if (entry == null) {
            this.logger().warn("{} - Rejected {}: request entry not found in local log", this.context.clusterManager().localNode(), (Object)request);
            return new PingResponse(request.id(), this.context.currentTerm(), false);
        }
        if (entry.term() != request.logTerm()) {
            this.logger().warn("{} - Rejected {}: request entry term does not match local log", this.context.clusterManager().localNode(), (Object)request);
            return new PingResponse(request.id(), this.context.currentTerm(), false);
        }
        this.doApplyCommits(request.commitIndex());
        return new PingResponse(request.id(), this.context.currentTerm(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        StateContext stateContext = this.context;
        synchronized (stateContext) {
            StateController stateController = this;
            synchronized (stateController) {
                CompletableFuture<SyncResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleSync(this.logRequest(request))));
                if (this.transition.get()) {
                    this.context.transition(FollowerController.class);
                }
                return future;
            }
        }
    }

    private synchronized SyncResponse handleSync(SyncRequest request) {
        if (request.term() > this.context.currentTerm() || request.term() == this.context.currentTerm() && this.context.currentLeader() == null) {
            this.context.currentTerm(request.term());
            this.context.currentLeader(request.leader());
            this.transition.set(true);
        }
        if (request.term() < this.context.currentTerm()) {
            this.logger().warn("{} - SyncRequest Rejected {}: request term ({}) is less than the current term ({})", new Object[]{this.context.clusterManager().localNode(), request.id(), request.term(), this.context.currentTerm()});
            this.logger().debug("{} - Rejected {}: sync request term is less than the current term ({})", new Object[]{this.context.clusterManager().localNode(), request, this.context.currentTerm()});
            return new SyncResponse(request.id(), this.context.currentTerm(), false, this.context.log().lastIndex());
        }
        if (request.prevLogIndex() > 0L && request.prevLogTerm() > 0L) {
            return this.doCheckPreviousEntry(request);
        }
        return this.doAppendEntries(request);
    }

    private synchronized SyncResponse doCheckPreviousEntry(SyncRequest request) {
        if (request.prevLogIndex() > this.context.log().lastIndex()) {
            this.logger().warn("{} - Rejected SyncRequest {}: previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.clusterManager().localNode(), request.id(), request.prevLogIndex(), this.context.log().lastIndex()});
            this.logger().debug("{} - Rejected {}: previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.clusterManager().localNode(), request, request.prevLogIndex(), this.context.log().lastIndex()});
            return new SyncResponse(request.id(), this.context.currentTerm(), false, this.context.log().lastIndex());
        }
        CopycatEntry entry = (CopycatEntry)this.context.log().getEntry(request.prevLogIndex());
        if (entry == null) {
            this.logger().warn("{} - Rejected SyncRequest {}: request entry not found in local log", this.context.clusterManager().localNode(), request.id());
            this.logger().debug("{} - Rejected {}: request entry not found in local log", this.context.clusterManager().localNode(), (Object)request);
            return new SyncResponse(request.id(), this.context.currentTerm(), false, this.context.log().lastIndex());
        }
        if (entry.term() != request.prevLogTerm()) {
            this.logger().warn("{} - Rejected SyncRequest {}: request entry prev term ({}) does not match local log ({})", new Object[]{this.context.clusterManager().localNode(), request.id(), request.prevLogTerm(), entry.term()});
            this.logger().debug("{} - Rejected {}: request entry prev term ({}) does not match local log ({})", new Object[]{this.context.clusterManager().localNode(), request, request.prevLogTerm(), entry.term()});
            return new SyncResponse(request.id(), this.context.currentTerm(), false, this.context.log().lastIndex());
        }
        return this.doAppendEntries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SyncResponse doAppendEntries(SyncRequest request) {
        if (!request.entries().isEmpty()) {
            Log log = this.context.log();
            synchronized (log) {
                long index = request.prevLogIndex();
                for (CopycatEntry entry : request.entries()) {
                    ++index;
                    if (entry instanceof SnapshotEntry) {
                        this.installSnapshot(index, (SnapshotEntry)entry);
                        continue;
                    }
                    CopycatEntry match = (CopycatEntry)this.context.log().getEntry(index);
                    if (match != null) {
                        if (entry.term() == match.term()) continue;
                        this.logger().warn("{} - Synced entry does not match local log, removing incorrect entries", this.context.clusterManager().localNode());
                        this.context.log().removeAfter(index - 1L);
                        this.context.log().appendEntry(entry);
                        this.logger().debug("{} - Appended {} to log at index {}", new Object[]{this.context.clusterManager().localNode(), entry, index});
                        continue;
                    }
                    this.context.log().appendEntry(entry);
                    this.logger().debug("{} - Appended {} to log at index {}", new Object[]{this.context.clusterManager().localNode(), entry, index});
                }
            }
        }
        this.doApplyCommits(request.commitIndex());
        return new SyncResponse(request.id(), this.context.currentTerm(), true, this.context.log().lastIndex());
    }

    private synchronized void doApplyCommits(long commitIndex) {
        if (commitIndex > this.context.commitIndex() || this.context.commitIndex() > this.context.lastApplied()) {
            long lastIndex = this.context.log().lastIndex();
            this.context.commitIndex(Math.min(Math.max(commitIndex, this.context.commitIndex()), lastIndex));
            if (this.context.commitIndex() > this.context.lastApplied()) {
                long firstEntryToApply;
                for (long i = firstEntryToApply = Math.max(this.context.lastApplied() + 1L, this.context.log().firstIndex()); i <= Math.min(this.context.commitIndex(), lastIndex); ++i) {
                    this.applyEntry(i);
                }
                this.compactLog();
            }
        }
    }

    private synchronized void installSnapshot(long index, SnapshotEntry entry) {
        this.logger().info("{} - Installing snapshot {}", this.context.clusterManager().localNode(), (Object)entry);
        this.logger().info("{} - Compacting log", this.context.clusterManager().localNode());
        try {
            this.context.log().compact(index, entry);
        }
        catch (IOException e) {
            this.logger().error(e.getMessage());
        }
        this.applySnapshot(index, entry);
        this.context.commitIndex(index);
        this.context.lastApplied(index);
    }

    protected void applyEntry(long index) {
        this.applyEntry(index, (Entry)this.context.log().getEntry(index));
    }

    protected void applyEntry(long index, Entry entry) {
        if (this.context.lastApplied() == index - 1L || this.context.log().firstIndex() == index) {
            if (entry == null) {
                throw new IllegalStateException("null entry at index " + index + " cannot be applied to state machine");
            }
            if (entry instanceof OperationEntry) {
                this.applyCommand(index, (OperationEntry)entry);
            } else if (entry instanceof ConfigurationEntry) {
                this.applyConfig(index, (ConfigurationEntry)entry);
            } else if (entry instanceof SnapshotEntry) {
                this.applySnapshot(index, (SnapshotEntry)entry);
            } else {
                this.context.lastApplied(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCommand(long index, OperationEntry entry) {
        try {
            this.logger().debug("{} - Apply operation: {}", this.context.clusterManager().localNode(), (Object)entry.operation());
            StateMachineExecutor.Operation operation = this.context.stateMachineExecutor().getOperation(entry.operation());
            if (operation != null) {
                operation.apply(entry.args());
            }
        }
        catch (Exception e) {
        }
        finally {
            this.context.lastApplied(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyConfig(long index, ConfigurationEntry entry) {
        try {
            this.logger().debug("{} - Apply configuration change: {}", this.context.clusterManager().localNode(), entry.cluster());
            this.context.clusterManager().cluster().update(entry.cluster(), null);
            ((DefaultEventHandlerRegistry)this.context.events().membershipChange()).handle(new MembershipChangeEvent(entry.cluster().getMembers()));
        }
        catch (Exception e) {
        }
        finally {
            this.context.lastApplied(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySnapshot(long index, SnapshotEntry entry) {
        this.logger().debug("{} - Apply snapshot: {}", this.context.clusterManager().localNode(), entry.cluster());
        Log log = this.context.log();
        synchronized (log) {
            this.context.stateMachineExecutor().stateMachine().installSnapshot(entry.data());
            try {
                this.logger().debug("{} - Compacting log", this.context.clusterManager().localNode());
                this.context.log().compact(index, entry);
            }
            catch (IOException e) {
                throw new CopycatException(e, "Failed to compact log.", new Object[0]);
            }
            this.context.clusterManager().cluster().update(entry.cluster(), null);
            ((DefaultEventHandlerRegistry)this.context.events().membershipChange()).handle(new MembershipChangeEvent(entry.cluster().getMembers()));
            this.context.currentTerm(Math.max(this.context.currentTerm(), entry.term()));
            this.context.lastApplied(index);
        }
    }

    protected SnapshotEntry createSnapshot() {
        byte[] snapshot = this.context.stateMachineExecutor().stateMachine().takeSnapshot();
        if (snapshot != null) {
            return new SnapshotEntry(this.context.currentTerm(), (ClusterConfig)this.context.clusterManager().cluster().config().copy(), snapshot);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> compactLog() {
        if (this.context.log().size() > (long)this.context.config().getMaxLogSize()) {
            Log log = this.context.log();
            synchronized (log) {
                this.logger().info("{} - Compacting log", this.context.clusterManager().localNode());
                long lastApplied = this.context.lastApplied();
                SnapshotEntry snapshot = this.createSnapshot();
                if (snapshot != null) {
                    try {
                        double before = (double)this.context.log().size() / 1048576.0;
                        this.context.log().compact(lastApplied, snapshot);
                        double after = (double)this.context.log().size() / 1048576.0;
                        this.logger().info("{} - Compacted log: {} -> {} MB", new Object[]{this.context.clusterManager().localNode(), before, after});
                    }
                    catch (IOException e) {
                        throw new CopycatException(e, "Failed to compact log.", new Object[0]);
                    }
                } else {
                    this.logger().warn("{} - Failed to compact log: no snapshot data provided", this.context.clusterManager().localNode());
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        this.logger().debug("{} - Received {}", this.context.clusterManager().localNode(), (Object)request);
        return CompletableFuture.completedFuture(this.logResponse(this.handlePoll(this.logRequest(request))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollResponse handlePoll(PollRequest request) {
        if (request.term() > this.context.currentTerm()) {
            this.context.currentTerm(request.term());
            this.context.lastVotedFor(null);
        }
        if (request.term() < this.context.currentTerm()) {
            this.logger().warn("{} - Rejected {}: candidate's term is less than the current term", this.context.clusterManager().localNode(), (Object)request);
            return new PollResponse(request.id(), this.context.currentTerm(), false);
        }
        if (request.candidate().equals(((Member)this.context.clusterManager().localNode().member()).id())) {
            this.context.currentLeader(null);
            this.context.lastVotedFor(((Member)this.context.clusterManager().localNode().member()).id());
            ((DefaultEventHandlerRegistry)this.context.events().voteCast()).handle(new VoteCastEvent(this.context.currentTerm(), (Member)this.context.clusterManager().localNode().member()));
            this.logger().debug("{} - Accepted {}: candidate is the local node", this.context.clusterManager().localNode(), (Object)request);
            return new PollResponse(request.id(), this.context.currentTerm(), true);
        }
        if (this.context.clusterManager().node(request.candidate()) == null) {
            this.logger().warn("{} - Rejected {}: candidate is not known to the local node", this.context.clusterManager().localNode(), (Object)request);
            return new PollResponse(request.id(), this.context.currentTerm(), false);
        }
        if (this.context.lastVotedFor() == null || this.context.lastVotedFor().equals(request.candidate())) {
            if (this.context.log().isEmpty()) {
                this.context.currentLeader(null);
                this.context.lastVotedFor(request.candidate());
                ((DefaultEventHandlerRegistry)this.context.events().voteCast()).handle(new VoteCastEvent(this.context.currentTerm(), (Member)((Node)this.context.clusterManager().node(request.candidate())).member()));
                this.logger().debug("{} - Accepted {}: candidate's log is up-to-date", this.context.clusterManager().localNode(), (Object)request);
                return new PollResponse(request.id(), this.context.currentTerm(), true);
            }
            Log log = this.context.log();
            synchronized (log) {
                long lastIndex = this.context.log().lastIndex();
                CopycatEntry entry = (CopycatEntry)this.context.log().getEntry(lastIndex);
                if (entry == null) {
                    this.context.currentLeader(null);
                    this.context.lastVotedFor(request.candidate());
                    ((DefaultEventHandlerRegistry)this.context.events().voteCast()).handle(new VoteCastEvent(this.context.currentTerm(), (Member)((Node)this.context.clusterManager().node(request.candidate())).member()));
                    this.logger().debug("{} - Accepted {}: candidate's log is up-to-date", this.context.clusterManager().localNode(), (Object)request);
                    return new PollResponse(request.id(), this.context.currentTerm(), true);
                }
                long lastTerm = entry.term();
                if (request.lastLogIndex() >= lastIndex) {
                    if (request.lastLogTerm() >= lastTerm) {
                        this.context.currentLeader(null);
                        this.context.lastVotedFor(request.candidate());
                        ((DefaultEventHandlerRegistry)this.context.events().voteCast()).handle(new VoteCastEvent(this.context.currentTerm(), (Member)((Node)this.context.clusterManager().node(request.candidate())).member()));
                        this.logger().debug("{} - Accepted {}: candidate's log is up-to-date", this.context.clusterManager().localNode(), (Object)request);
                        return new PollResponse(request.id(), this.context.currentTerm(), true);
                    }
                    this.logger().warn("{} - Rejected {}: candidate's last log term ({}) is in conflict with local log ({})", new Object[]{this.context.clusterManager().localNode(), request, request.lastLogTerm(), lastTerm});
                    return new PollResponse(request.id(), this.context.currentTerm(), false);
                }
                this.logger().warn("{} - Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{this.context.clusterManager().localNode(), request, request.lastLogIndex(), lastIndex});
                return new PollResponse(request.id(), this.context.currentTerm(), false);
            }
        }
        this.logger().warn("{} - Rejected {}: already voted for {}", new Object[]{this.context.clusterManager().localNode(), request, this.context.lastVotedFor()});
        return new PollResponse(request.id(), this.context.currentTerm(), false);
    }

    @Override
    public CompletableFuture<SubmitResponse> submit(SubmitRequest request) {
        RemoteNode leader;
        StateMachineExecutor.Operation operation;
        this.logRequest(request);
        CompletableFuture<SubmitResponse> future = new CompletableFuture<SubmitResponse>();
        if (!this.context.config().isConsistentQueryExecution() && (operation = this.context.stateMachineExecutor().getOperation(request.operation())) != null && operation.isReadOnly()) {
            try {
                future.complete(this.logResponse(new SubmitResponse(request.id(), operation.apply(request.args()))));
            }
            catch (Exception e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }
        if (this.context.currentLeader() != null && (leader = this.context.clusterManager().remoteNode(this.context.currentLeader())) != null) {
            this.logger().debug("{} - Forwarding {} to leader {}", new Object[]{this.context.clusterManager().localNode(), request, leader});
            leader.client().connect().whenComplete((r, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    leader.client().submit(request).whenComplete((result, error) -> {
                        if (error != null) {
                            future.completeExceptionally((Throwable)error);
                        } else {
                            future.complete((SubmitResponse)result);
                        }
                    });
                }
            });
            return future;
        }
        return CompletableFuture.completedFuture(this.logResponse(new SubmitResponse(request.id(), "Not the leader")));
    }

    void destroy() {
        this.context.clusterManager().localNode().server().requestHandler(null);
    }

    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }
}

