/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.util;

public final class Assert {
    private Assert() {
    }

    public static <T> T isNotNull(T value, String parameterName) {
        if (value == null) {
            throw new NullPointerException(String.format("%s cannot be null", parameterName));
        }
        return value;
    }

    public static <T> T isNull(T value, String message, Object ... args) {
        if (value != null) {
            throw new NullPointerException(String.format(message, args));
        }
        return value;
    }

    public static void state(boolean state, String message, Object ... args) {
        if (!state) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static <T> T arg(T value, boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, args));
        }
        return value;
    }
}

