/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class Reflection {
    private Reflection() {
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> clazz = method.getDeclaringClass().getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            annotation = Reflection.findMethodAnnotationInInterface(method, clazz, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static <A extends Annotation> A findMethodAnnotationInInterface(Method method, Class<?> clazz, Class<A> annotationType) {
        try {
            Method matchMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            A annotation = matchMethod.getAnnotation(annotationType);
            if (annotation != null) {
                return annotation;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<?> i : clazz.getInterfaces()) {
            A annotation = Reflection.findMethodAnnotationInInterface(method, i, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

