/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.kuujo.copycat.log.BaseLog;
import net.kuujo.copycat.log.Entry;

abstract class BaseFileLog
extends BaseLog {
    private static final SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    private final File baseFile;

    protected BaseFileLog(File baseFile, Class<? extends Entry> entryType) {
        super(entryType);
        this.baseFile = baseFile;
    }

    protected final File findLogFile() {
        this.baseFile.getAbsoluteFile().getParentFile().mkdirs();
        File logFile = null;
        long logTime = 0L;
        for (File file : this.baseFile.getAbsoluteFile().getParentFile().listFiles(File::isFile)) {
            if (!file.getName().contains(".") || !file.getName().substring(0, file.getName().indexOf(46)).equals(this.baseFile.getName())) continue;
            try {
                long fileTime = fileNameFormat.parse(file.getName().substring(file.getName().indexOf(46) + 1, file.getName().indexOf(46, file.getName().indexOf(46) + 1))).getTime();
                if (fileTime <= logTime) continue;
                logFile = new File(file.getAbsoluteFile().getParentFile().getAbsolutePath(), file.getName().substring(0, file.getName().indexOf(46, file.getName().indexOf(46) + 1)));
                logTime = fileTime;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (logFile == null) {
            logFile = this.createLogFile();
        }
        return logFile;
    }

    protected final File createLogFile() {
        return new File(this.baseFile.getAbsoluteFile().getParentFile().getAbsolutePath(), String.format("%s.%s", this.baseFile.getName(), fileNameFormat.format(new Date())));
    }

    protected final File createTempFile() {
        return new File(this.baseFile.getAbsoluteFile().getParentFile().getAbsolutePath(), String.format("%s.%s.temp", this.baseFile.getName(), fileNameFormat.format(new Date())));
    }

    protected final void moveTempFile(File tempFile, File newFile) throws IOException {
        for (File file : this.baseFile.getAbsoluteFile().getParentFile().listFiles(File::isFile)) {
            if (!file.getName().startsWith(tempFile.getName())) continue;
            Files.move(file.toPath(), new File(file.getParentFile(), String.format("%s%s", newFile.getName(), file.getName().substring(tempFile.getName().length()))).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected final void deleteLogFile(File logFile) {
        for (File file : this.baseFile.getAbsoluteFile().getParentFile().listFiles(File::isFile)) {
            if (!file.getName().startsWith(logFile.getName())) continue;
            file.delete();
        }
    }
}

