/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import com.esotericsoftware.kryo.Kryo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.log.Entry;
import net.kuujo.copycat.log.EntryType;
import net.kuujo.copycat.log.EntryTypes;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.log.LogException;

abstract class BaseLog
implements Log {
    private final Class<? extends Entry> entryType;
    protected final Kryo kryo;

    protected BaseLog(Class<? extends Entry> entryType) {
        this.entryType = entryType;
        this.kryo = new Kryo();
        this.init();
    }

    @Override
    public List<Long> appendEntries(Entry ... entries) {
        Assert.isNotNull(entries, "entries");
        this.assertIsOpen();
        return Arrays.stream(entries).map(entry -> this.appendEntry((Entry)entry)).collect(Collectors.toList());
    }

    @Override
    public List<Long> appendEntries(List<Entry> entries) {
        Assert.isNotNull(entries, "entries");
        this.assertIsOpen();
        return entries.stream().map(entry -> this.appendEntry((Entry)entry)).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this.size());
    }

    protected void assertIsOpen() {
        Assert.state(this.isOpen(), "The log is not currently open.", new Object[0]);
    }

    protected void assertIsNotOpen() {
        Assert.state(!this.isOpen(), "The log is already open.", new Object[0]);
    }

    private EntryType findEntryTypeInfo(Class<?> clazz) {
        while (clazz != Object.class && clazz != null) {
            EntryType info = clazz.getAnnotation(EntryType.class);
            if (info != null) {
                return info;
            }
            clazz = clazz.getSuperclass();
        }
        throw new LogException("Invalid entry type. No type info found.", new Object[0]);
    }

    private EntryTypes findEntryTypes(Class<?> clazz) {
        while (clazz != Object.class && clazz != null) {
            EntryTypes types = clazz.getAnnotation(EntryTypes.class);
            if (types != null) {
                return types;
            }
            clazz = clazz.getSuperclass();
        }
        throw new LogException("Invalid entry type. No type mappings found.", new Object[0]);
    }

    private void init() {
        for (Class<? extends Entry> type : this.findEntryTypes(this.entryType).value()) {
            EntryType info = this.findEntryTypeInfo(type);
            try {
                this.kryo.register(type, info.serializer().newInstance(), info.id());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new LogException(e, "Failed to instantiate serializer %s", info.serializer().getName());
            }
        }
    }
}

