/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.log;

import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.log.BaseLog;
import net.kuujo.copycat.log.Entry;
import net.kuujo.copycat.log.LogIndexOutOfBoundsException;

public class InMemoryLog
extends BaseLog {
    private TreeMap<Long, byte[]> log;
    private volatile long size;
    private final ByteBuffer buffer = ByteBuffer.allocate(4096);
    private final ByteBufferOutput output = new ByteBufferOutput(this.buffer);
    private final ByteBufferInput input = new ByteBufferInput(this.buffer);

    public InMemoryLog() {
        super(CopycatEntry.class);
    }

    public InMemoryLog(Class<? extends Entry> entryType) {
        super(entryType);
    }

    @Override
    public synchronized long appendEntry(Entry entry) {
        Assert.isNotNull(entry, "entry");
        this.assertIsOpen();
        long index = this.log.isEmpty() ? 1L : this.log.lastKey() + 1L;
        this.kryo.writeClassAndObject(this.output, entry);
        byte[] bytes = this.output.toBytes();
        this.log.put(index, bytes);
        this.size += (long)bytes.length;
        this.output.clear();
        return index;
    }

    @Override
    public void close() {
        this.assertIsOpen();
        this.log = null;
    }

    @Override
    public synchronized void compact(long index, Entry entry) throws IOException {
        Assert.isNotNull(entry, "entry");
        this.assertIsOpen();
        this.kryo.writeClassAndObject(this.output, entry);
        byte[] bytes = this.output.toBytes();
        this.output.clear();
        this.log.headMap(index).clear();
        this.log.put(index, bytes);
        long newSize = 0L;
        for (Map.Entry<Long, byte[]> e : this.log.entrySet()) {
            newSize += (long)e.getValue().length;
        }
        this.size = newSize;
    }

    @Override
    public synchronized boolean containsEntry(long index) {
        this.assertIsOpen();
        return this.log.containsKey(index);
    }

    @Override
    public void delete() {
        this.log = null;
    }

    @Override
    public synchronized <T extends Entry> T firstEntry() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? (T)this.getEntry(this.log.firstKey()) : null;
    }

    @Override
    public synchronized long firstIndex() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? this.log.firstKey() : 0L;
    }

    @Override
    public synchronized <T extends Entry> List<T> getEntries(long from, long to) {
        this.assertIsOpen();
        if (this.log.isEmpty()) {
            throw new LogIndexOutOfBoundsException("Log is empty", new Object[0]);
        }
        if (from < this.log.firstKey()) {
            throw new LogIndexOutOfBoundsException("From index out of bounds.", new Object[0]);
        }
        if (to > this.log.lastKey()) {
            throw new LogIndexOutOfBoundsException("To index out of bounds.", new Object[0]);
        }
        ArrayList<T> entries = new ArrayList<T>((int)(to - from + 1L));
        for (long i = from; i <= to; ++i) {
            T entry = this.getEntry(i);
            if (entry == null) continue;
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public synchronized <T extends Entry> T getEntry(long index) {
        this.assertIsOpen();
        byte[] bytes = this.log.get(index);
        if (bytes != null) {
            this.buffer.put(bytes);
            this.buffer.rewind();
            this.input.setBuffer(this.buffer);
            Entry entry = (Entry)this.kryo.readClassAndObject(this.input);
            this.buffer.clear();
            return (T)entry;
        }
        return null;
    }

    @Override
    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.log.isEmpty();
    }

    @Override
    public boolean isOpen() {
        return this.log != null;
    }

    @Override
    public synchronized <T extends Entry> T lastEntry() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? (T)this.getEntry(this.log.lastKey()) : null;
    }

    @Override
    public synchronized long lastIndex() {
        this.assertIsOpen();
        return !this.log.isEmpty() ? this.log.lastKey() : 0L;
    }

    @Override
    public synchronized void open() {
        this.assertIsNotOpen();
        this.log = new TreeMap();
    }

    @Override
    public synchronized void removeAfter(long index) {
        this.assertIsOpen();
        if (!this.log.isEmpty()) {
            for (long i = index + 1L; i <= this.log.lastKey(); ++i) {
                byte[] value = this.log.remove(i);
                if (value == null) continue;
                this.size -= (long)value.length;
            }
        }
    }

    @Override
    public synchronized long size() {
        this.assertIsOpen();
        return this.size;
    }

    @Override
    public void sync() {
        this.assertIsOpen();
    }

    @Override
    public String toString() {
        return String.format("Follower[size=%d]", this.size());
    }
}

