/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.protocol.LocalProtocolServer;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.ProtocolException;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import net.kuujo.copycat.spi.protocol.ProtocolClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProtocolClient
implements ProtocolClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProtocolClient.class);
    private final String id;
    private final Map<String, LocalProtocolServer> registry;

    public LocalProtocolClient(String id, Map<String, LocalProtocolServer> registry) {
        this.id = id;
        this.registry = registry;
    }

    @Override
    public CompletableFuture<PingResponse> ping(PingRequest request) {
        LocalProtocolServer server = this.registry.get(this.id);
        if (server == null) {
            CompletableFuture<PingResponse> future = new CompletableFuture<PingResponse>();
            future.completeExceptionally(new ProtocolException("Invalid server address: %s", this.id));
            return future;
        }
        return server.ping(request);
    }

    @Override
    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        LocalProtocolServer server = this.registry.get(this.id);
        if (server == null) {
            CompletableFuture<SyncResponse> future = new CompletableFuture<SyncResponse>();
            future.completeExceptionally(new ProtocolException("Invalid server address: %s", this.id));
            return future;
        }
        return server.sync(request);
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        LocalProtocolServer server = this.registry.get(this.id);
        if (server == null) {
            CompletableFuture<PollResponse> future = new CompletableFuture<PollResponse>();
            future.completeExceptionally(new ProtocolException("Invalid server address: %s", this.id));
            return future;
        }
        return server.poll(request);
    }

    @Override
    public CompletableFuture<SubmitResponse> submit(SubmitRequest request) {
        LocalProtocolServer server = this.registry.get(this.id);
        if (server == null) {
            CompletableFuture<SubmitResponse> future = new CompletableFuture<SubmitResponse>();
            future.completeExceptionally(new ProtocolException("Invalid server address: %s", this.id));
            return future;
        }
        return server.submit(request);
    }

    @Override
    public CompletableFuture<Void> connect() {
        LOGGER.debug("{} connecting to {}", (Object)this, (Object)this.id);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> close() {
        LOGGER.debug("{} closing connection to {}", (Object)this, (Object)this.id);
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("%s[id=%s]", this.getClass().getSimpleName(), this.id);
    }
}

