/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.kuujo.copycat.internal.util.Assert;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.RequestHandler;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import net.kuujo.copycat.spi.protocol.ProtocolServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProtocolServer
implements ProtocolServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProtocolServer.class);
    private final String id;
    private final Map<String, LocalProtocolServer> registry;
    private RequestHandler requestHandler;

    public LocalProtocolServer(String id, Map<String, LocalProtocolServer> registry) {
        this.id = id;
        this.registry = registry;
    }

    @Override
    public void requestHandler(RequestHandler handler) {
        this.requestHandler = handler;
    }

    CompletableFuture<PingResponse> ping(PingRequest request) {
        Assert.isNotNull(this.requestHandler, "No protocol handler provided");
        return this.requestHandler.ping(request);
    }

    CompletableFuture<SyncResponse> sync(SyncRequest request) {
        Assert.isNotNull(this.requestHandler, "No protocol handler provided");
        return this.requestHandler.sync(request);
    }

    CompletableFuture<PollResponse> poll(PollRequest request) {
        Assert.isNotNull(this.requestHandler, "No protocol handler provided");
        return this.requestHandler.poll(request);
    }

    CompletableFuture<SubmitResponse> submit(SubmitRequest request) {
        Assert.isNotNull(this.requestHandler, "No protocol handler provided");
        return this.requestHandler.submit(request);
    }

    @Override
    public CompletableFuture<Void> listen() {
        LOGGER.debug("{} listening at {}", (Object)this, (Object)this.id);
        this.registry.put(this.id, this);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> close() {
        LOGGER.debug("{} closing server at {}", (Object)this, (Object)this.id);
        this.registry.remove(this.id);
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("%s[id=%s]", this.getClass().getSimpleName(), this.id);
    }
}

