/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import java.util.List;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.Request;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;

public class ProtocolReader {
    private static final byte PING_REQUEST = 0;
    private static final byte PING_RESPONSE = 1;
    private static final byte SYNC_REQUEST = 2;
    private static final byte SYNC_RESPONSE = 3;
    private static final byte POLL_REQUEST = 4;
    private static final byte POLL_RESPONSE = 5;
    private static final byte SUBMIT_REQUEST = 6;
    private static final byte SUBMIT_RESPONSE = 7;

    public <T extends Request> T readRequest(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte type = buffer.get();
        switch (type) {
            case 0: {
                return (T)this.pingRequest(buffer);
            }
            case 2: {
                return (T)this.syncRequest(buffer);
            }
            case 4: {
                return (T)this.pollRequest(buffer);
            }
            case 6: {
                return (T)this.submitRequest(buffer);
            }
        }
        throw new RuntimeException("Invalid request type");
    }

    private PingRequest pingRequest(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        int leaderLength = buffer.getInt();
        byte[] leaderBytes = new byte[leaderLength];
        buffer.get(leaderBytes);
        String leader = new String(leaderBytes);
        long logIndex = buffer.getLong();
        long logTerm = buffer.getLong();
        long commitIndex = buffer.getLong();
        return new PingRequest(id, term, leader, logIndex, logTerm, commitIndex);
    }

    private SyncRequest syncRequest(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        int leaderLength = buffer.getInt();
        byte[] leaderBytes = new byte[leaderLength];
        buffer.get(leaderBytes);
        String leader = new String(leaderBytes);
        long prevLogIndex = buffer.getLong();
        long prevLogTerm = buffer.getLong();
        int entriesLength = buffer.getInt();
        byte[] entriesBytes = new byte[entriesLength];
        buffer.get(entriesBytes);
        List entries = (List)this.deserializeObject(entriesBytes);
        long commitIndex = buffer.getLong();
        return new SyncRequest(id, term, leader, prevLogIndex, prevLogTerm, entries, commitIndex);
    }

    private PollRequest pollRequest(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        int candidateLength = buffer.getInt();
        byte[] candidateBytes = new byte[candidateLength];
        buffer.get(candidateBytes);
        String candidate = new String(candidateBytes);
        long lastLogIndex = buffer.getLong();
        long lastLogTerm = buffer.getLong();
        return new PollRequest(id, term, candidate, lastLogIndex, lastLogTerm);
    }

    private SubmitRequest submitRequest(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        int commandLength = buffer.getInt();
        byte[] commandBytes = new byte[commandLength];
        buffer.get(commandBytes);
        String command = new String(commandBytes);
        int argsLength = buffer.getInt();
        byte[] argsBytes = new byte[argsLength];
        buffer.get(argsBytes);
        List args = (List)this.deserializeObject(argsBytes);
        return new SubmitRequest(id, command, args);
    }

    public <T extends Response> T readResponse(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte type = buffer.get();
        switch (type) {
            case 1: {
                return (T)this.pingResponse(buffer);
            }
            case 3: {
                return (T)this.syncResponse(buffer);
            }
            case 5: {
                return (T)this.pollResponse(buffer);
            }
            case 7: {
                return (T)this.submitResponse(buffer);
            }
        }
        throw new RuntimeException("Invalid response type");
    }

    private PingResponse pingResponse(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        boolean succeeded = buffer.getInt() == 1;
        return new PingResponse(id, term, succeeded);
    }

    private SyncResponse syncResponse(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        boolean succeeded = buffer.getInt() == 1;
        long lastLogIndex = buffer.getLong();
        return new SyncResponse(id, term, succeeded, lastLogIndex);
    }

    private PollResponse pollResponse(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        long term = buffer.getLong();
        boolean voteGranted = buffer.getInt() == 1;
        return new PollResponse(id, term, voteGranted);
    }

    private SubmitResponse submitResponse(ByteBuffer buffer) {
        int idLength = buffer.getInt();
        byte[] idBytes = new byte[idLength];
        buffer.get(idBytes);
        Object id = this.deserializeObject(idBytes);
        int resultLength = buffer.getInt();
        byte[] resultBytes = new byte[resultLength];
        buffer.get(resultBytes);
        Object result = this.deserializeObject(resultBytes);
        return new SubmitResponse(id, result);
    }

    private <T> T deserializeObject(byte[] bytes) {
        Object object;
        ObjectInputStream stream = null;
        try {
            stream = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), new ByteArrayInputStream(bytes));
            object = stream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return (T)object;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader cl;

        public ClassLoaderObjectInputStream(ClassLoader cl, InputStream in) throws IOException {
            super(in);
            this.cl = cl;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
            try {
                return this.cl.loadClass(desc.getName());
            }
            catch (Exception exception) {
                return super.resolveClass(desc);
            }
        }
    }
}

