/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.Request;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;

public class ProtocolWriter {
    private static final byte PING_REQUEST = 0;
    private static final byte PING_RESPONSE = 1;
    private static final byte SYNC_REQUEST = 2;
    private static final byte SYNC_RESPONSE = 3;
    private static final byte POLL_REQUEST = 4;
    private static final byte POLL_RESPONSE = 5;
    private static final byte SUBMIT_REQUEST = 6;
    private static final byte SUBMIT_RESPONSE = 7;

    public byte[] writeRequest(Request request) {
        if (request instanceof PingRequest) {
            return this.pingRequest((PingRequest)request);
        }
        if (request instanceof SyncRequest) {
            return this.syncRequest((SyncRequest)request);
        }
        if (request instanceof PollRequest) {
            return this.pollRequest((PollRequest)request);
        }
        if (request instanceof SubmitRequest) {
            return this.submitRequest((SubmitRequest)request);
        }
        throw new RuntimeException("Invalid request type");
    }

    private byte[] pingRequest(PingRequest request) {
        byte[] idBytes = this.serializeObject(request.id());
        byte[] leaderBytes = request.leader().getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(45 + idBytes.length + leaderBytes.length);
        buffer.put((byte)0);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(request.term());
        buffer.putInt(leaderBytes.length);
        buffer.put(leaderBytes);
        buffer.putLong(request.logIndex());
        buffer.putLong(request.logTerm());
        buffer.putLong(request.commitIndex());
        return buffer.array();
    }

    private byte[] syncRequest(SyncRequest request) {
        byte[] idBytes = this.serializeObject(request.id());
        byte[] leaderBytes = request.leader().getBytes();
        byte[] entriesBytes = this.serializeObject(request.entries());
        ByteBuffer buffer = ByteBuffer.allocate(45 + idBytes.length + leaderBytes.length + entriesBytes.length);
        buffer.put((byte)2);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(request.term());
        buffer.putInt(leaderBytes.length);
        buffer.put(leaderBytes);
        buffer.putLong(request.prevLogIndex());
        buffer.putLong(request.prevLogTerm());
        buffer.putInt(entriesBytes.length);
        buffer.put(entriesBytes);
        buffer.putLong(request.commitIndex());
        return buffer.array();
    }

    private byte[] pollRequest(PollRequest request) {
        byte[] idBytes = this.serializeObject(request.id());
        byte[] candidateBytes = request.candidate().getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(33 + idBytes.length + candidateBytes.length);
        buffer.put((byte)4);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(request.term());
        buffer.putInt(candidateBytes.length);
        buffer.put(candidateBytes);
        buffer.putLong(request.lastLogIndex());
        buffer.putLong(request.lastLogTerm());
        return buffer.array();
    }

    private byte[] submitRequest(SubmitRequest request) {
        byte[] idBytes = this.serializeObject(request.id());
        byte[] commandBytes = request.operation().getBytes();
        byte[] argsBytes = this.serializeObject(request.args());
        ByteBuffer buffer = ByteBuffer.allocate(13 + idBytes.length + commandBytes.length + argsBytes.length);
        buffer.put((byte)6);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putInt(commandBytes.length);
        buffer.put(commandBytes);
        buffer.putInt(argsBytes.length);
        buffer.put(argsBytes);
        return buffer.array();
    }

    public byte[] writeResponse(Response response) {
        if (response instanceof PingResponse) {
            return this.pingResponse((PingResponse)response);
        }
        if (response instanceof SyncResponse) {
            return this.syncResponse((SyncResponse)response);
        }
        if (response instanceof PollResponse) {
            return this.pollResponse((PollResponse)response);
        }
        if (response instanceof SubmitResponse) {
            return this.submitResponse((SubmitResponse)response);
        }
        throw new RuntimeException("Invalid response type");
    }

    private byte[] pingResponse(PingResponse response) {
        byte[] idBytes = this.serializeObject(response.id());
        ByteBuffer buffer = ByteBuffer.allocate(25 + idBytes.length);
        buffer.put((byte)1);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(response.term());
        buffer.putInt(response.succeeded() ? 1 : 0);
        return buffer.array();
    }

    private byte[] syncResponse(SyncResponse response) {
        byte[] idBytes = this.serializeObject(response.id());
        ByteBuffer buffer = ByteBuffer.allocate(25 + idBytes.length);
        buffer.put((byte)3);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(response.term());
        buffer.putInt(response.succeeded() ? 1 : 0);
        buffer.putLong(response.lastLogIndex());
        return buffer.array();
    }

    private byte[] pollResponse(PollResponse response) {
        byte[] idBytes = this.serializeObject(response.id());
        ByteBuffer buffer = ByteBuffer.allocate(17 + idBytes.length);
        buffer.put((byte)5);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putLong(response.term());
        buffer.putInt(response.voteGranted() ? 1 : 0);
        return buffer.array();
    }

    private byte[] submitResponse(SubmitResponse response) {
        byte[] idBytes = this.serializeObject(response.id());
        byte[] resultBytes = this.serializeObject(response.result());
        ByteBuffer buffer = ByteBuffer.allocate(9 + idBytes.length + resultBytes.length);
        buffer.put((byte)7);
        buffer.putInt(idBytes.length);
        buffer.put(idBytes);
        buffer.putInt(resultBytes.length);
        buffer.put(resultBytes);
        return buffer.array();
    }

    private byte[] serializeObject(Object object) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return byteStream.toByteArray();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

