/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.io.Serializable;
import net.kuujo.copycat.protocol.ResponseException;

public abstract class Response
implements Serializable {
    private final Object id;
    private final Status status;
    private final String error;

    protected Response() {
        this.id = null;
        this.status = Status.OK;
        this.error = null;
    }

    protected Response(Object id, Status status) {
        this.id = id;
        this.status = status;
        this.error = null;
    }

    protected Response(Object id, Status status, Throwable t) {
        this.id = id;
        this.status = status;
        this.error = t.getMessage();
    }

    protected Response(Object id, Status status, String error) {
        this.id = id;
        this.status = status;
        this.error = error;
    }

    public Object id() {
        return this.id;
    }

    public Status status() {
        return this.status;
    }

    public Throwable error() {
        return this.error != null ? new ResponseException(this.error, new Object[0]) : null;
    }

    public String toString() {
        return String.format("Response[id=%s, status=%s]", new Object[]{this.id, this.status});
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

