/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.protocol;

import java.util.List;
import net.kuujo.copycat.log.Entry;
import net.kuujo.copycat.protocol.Request;

public class SyncRequest
extends Request {
    private static final long serialVersionUID = 8870779945535041744L;
    private long term;
    private String leader;
    private long prevLogIndex;
    private long prevLogTerm;
    private List<? extends Entry> entries;
    private long commitIndex;

    public SyncRequest() {
        super(null);
    }

    public SyncRequest(Object id, long term, String leader, long prevLogIndex, long prevLogTerm, List<? extends Entry> entries, long commitIndex) {
        super(id);
        this.term = term;
        this.leader = leader;
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.entries = entries;
        this.commitIndex = commitIndex;
    }

    public long term() {
        return this.term;
    }

    public String leader() {
        return this.leader;
    }

    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    public long prevLogTerm() {
        return this.prevLogTerm;
    }

    public <T extends Entry> List<T> entries() {
        return this.entries;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public boolean equals(Object object) {
        if (object instanceof SyncRequest) {
            SyncRequest request = (SyncRequest)object;
            return request.id().equals(this.id()) && request.term == this.term && request.leader.equals(this.leader) && request.prevLogIndex == this.prevLogIndex && request.prevLogTerm == this.prevLogTerm && request.entries.equals(this.entries) && request.commitIndex == this.commitIndex;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + this.id().hashCode();
        hashCode = 37 * hashCode + (int)(this.term ^ this.term >>> 32);
        hashCode = 37 * hashCode + this.leader.hashCode();
        hashCode = 37 * hashCode + (int)(this.prevLogIndex ^ this.prevLogIndex >>> 32);
        hashCode = 37 * hashCode + (int)(this.prevLogTerm ^ this.prevLogTerm >>> 32);
        hashCode = 37 * hashCode + this.entries.hashCode();
        hashCode = 37 * hashCode + (int)(this.commitIndex ^ this.commitIndex >>> 32);
        return hashCode;
    }

    @Override
    public String toString() {
        return String.format("%s[id=%s, term=%d, leader=%s, prevLogIndex=%d, prevLogTerm=%d, commitIndex=%d, entries=%s]", this.getClass().getSimpleName(), this.id(), this.term, this.leader, this.prevLogIndex, this.prevLogTerm, this.commitIndex, this.entries);
    }
}

