/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import com.typesafe.config.ConfigValueFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.protocol.Protocol;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.internal.Assert;

public class ClusterConfig
extends AbstractConfigurable {
    private static final String CLUSTER_PROTOCOL = "protocol";
    private static final String CLUSTER_ELECTION_TIMEOUT = "election.timeout";
    private static final String CLUSTER_HEARTBEAT_INTERVAL = "heartbeat.interval";
    private static final String CLUSTER_LOCAL_MEMBER = "local-member";
    private static final String CLUSTER_MEMBERS = "members";
    private static final String CONFIGURATION = "cluster";
    private static final String DEFAULT_CONFIGURATION = "cluster-defaults";
    private Protocol protocol;

    public ClusterConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public ClusterConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public ClusterConfig(String resource) {
        super(ClusterConfig.addResources(new String[]{resource}, CONFIGURATION, DEFAULT_CONFIGURATION));
    }

    private ClusterConfig(ClusterConfig config) {
        super(config);
    }

    @Override
    public ClusterConfig copy() {
        return new ClusterConfig(this);
    }

    public void setProtocol(Protocol protocol) {
        this.config = this.config.withValue(CLUSTER_PROTOCOL, ConfigValueFactory.fromMap(Assert.isNotNull(protocol, CLUSTER_PROTOCOL).toMap()));
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol != null ? this.protocol : (Protocol)Configurable.load(this.config.getObject(CLUSTER_PROTOCOL).unwrapped());
    }

    public ClusterConfig withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setElectionTimeout(long electionTimeout) {
        this.config = this.config.withValue(CLUSTER_ELECTION_TIMEOUT, ConfigValueFactory.fromAnyRef(Assert.arg(electionTimeout, electionTimeout > 0L, "election timeout must be positive", new Object[0])));
    }

    public void setElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(unit.toMillis(electionTimeout));
    }

    public long getElectionTimeout() {
        return this.config.getLong(CLUSTER_ELECTION_TIMEOUT);
    }

    public ClusterConfig withElectionTimeout(long electionTimeout) {
        this.setElectionTimeout(electionTimeout);
        return this;
    }

    public ClusterConfig withElectionTimeout(long electionTimeout, TimeUnit unit) {
        this.setElectionTimeout(electionTimeout, unit);
        return this;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.config = this.config.withValue(CLUSTER_HEARTBEAT_INTERVAL, ConfigValueFactory.fromAnyRef(Assert.arg(heartbeatInterval, heartbeatInterval > 0L, "heartbeat interval must be positive", new Object[0])));
    }

    public void setHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(unit.toMillis(heartbeatInterval));
    }

    public long getHeartbeatInterval() {
        return this.config.getLong(CLUSTER_HEARTBEAT_INTERVAL);
    }

    public ClusterConfig withHeartbeatInterval(long heartbeatInterval) {
        this.setHeartbeatInterval(heartbeatInterval);
        return this;
    }

    public ClusterConfig withHeartbeatInterval(long heartbeatInterval, TimeUnit unit) {
        this.setHeartbeatInterval(heartbeatInterval, unit);
        return this;
    }

    public void setLocalMember(String uri) {
        this.config = uri != null ? this.config.withValue(CLUSTER_LOCAL_MEMBER, ConfigValueFactory.fromAnyRef(uri)) : this.config.withoutPath(CLUSTER_LOCAL_MEMBER);
    }

    public String getLocalMember() {
        return this.config.hasPath(CLUSTER_LOCAL_MEMBER) ? this.config.getString(CLUSTER_LOCAL_MEMBER) : null;
    }

    public ClusterConfig withLocalMember(String uri) {
        this.setLocalMember(uri);
        return this;
    }

    public void setMembers(String ... uris) {
        this.setMembers(new ArrayList<String>(Arrays.asList(uris)));
    }

    public void setMembers(Collection<String> uris) {
        Assert.isNotNull(uris, "uris");
        HashSet<String> members = new HashSet<String>(uris.size());
        for (String uri : uris) {
            try {
                members.add(Assert.isNotNull(Assert.arg(uri, this.getProtocol().isValidUri(new URI(uri)), "invalid protocol URI", new Object[0]), "uri"));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.config = this.config.withValue(CLUSTER_MEMBERS, ConfigValueFactory.fromIterable(new HashSet(Assert.isNotNull(members, CLUSTER_MEMBERS))));
    }

    public Set<String> getMembers() {
        return new HashSet<String>(this.config.hasPath(CLUSTER_MEMBERS) ? this.config.getList(CLUSTER_MEMBERS).unwrapped() : new ArrayList(0));
    }

    public ClusterConfig addMember(String uri) {
        if (!this.config.hasPath(CLUSTER_MEMBERS)) {
            this.config = this.config.withValue(CLUSTER_MEMBERS, ConfigValueFactory.fromIterable(new ArrayList(1)));
        }
        List<Object> members = this.config.getList(CLUSTER_MEMBERS).unwrapped();
        try {
            members.add(Assert.arg(Assert.isNotNull(uri, "uri"), this.getProtocol().isValidUri(new URI(uri)), "invalid protocol URI", new Object[0]));
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid protocol URI", new Object[]{e});
        }
        this.config = this.config.withValue(CLUSTER_MEMBERS, ConfigValueFactory.fromIterable(members));
        return this;
    }

    public ClusterConfig withMembers(String ... uris) {
        this.setMembers(uris);
        return this;
    }

    public ClusterConfig withMembers(Collection<String> uris) {
        this.setMembers(uris);
        return this;
    }

    public ClusterConfig addMembers(String ... uris) {
        return this.addMembers(Arrays.asList(uris));
    }

    public ClusterConfig addMembers(Collection<String> uris) {
        Assert.isNotNull(uris, "uris");
        uris.forEach(this::addMember);
        return this;
    }

    public ClusterConfig removeMember(String uri) {
        List<Object> members = this.config.getList(CLUSTER_MEMBERS).unwrapped();
        members.remove(Assert.isNotNull(uri, "uri"));
        this.config = this.config.withValue(CLUSTER_MEMBERS, ConfigValueFactory.fromIterable(members));
        return this;
    }

    public ClusterConfig removeMembers(String ... uris) {
        return this.removeMembers(Arrays.asList(uris));
    }

    public ClusterConfig removeMembers(Collection<String> uris) {
        uris.forEach(this::removeMember);
        return this;
    }

    public ClusterConfig clearMembers() {
        this.config = this.config.withoutPath(CLUSTER_MEMBERS);
        return this;
    }
}

