/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster;

import java.util.Objects;
import java.util.UUID;
import net.kuujo.copycat.Event;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.util.internal.Assert;

public class MembershipEvent
implements Event<Type> {
    private final String id = UUID.randomUUID().toString();
    private final Type type;
    private final Member member;

    public MembershipEvent(Type type, Member member) {
        this.type = Assert.isNotNull(type, "type");
        this.member = Assert.isNotNull(member, "member");
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public Member member() {
        return this.member;
    }

    public boolean equals(Object object) {
        return object instanceof MembershipEvent && ((MembershipEvent)object).id.equals(this.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.member});
    }

    public String toString() {
        return String.format("%s[id=%s, type=%s, member=%s]", new Object[]{this.getClass().getSimpleName(), this.id, this.type, this.member});
    }

    public static enum Type {
        JOIN,
        LEAVE;

    }
}

