/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.kuujo.copycat.cluster.Member;

public class MemberInfo
implements Serializable {
    private static final int FAILURE_LIMIT = 3;
    private Member.Type type;
    private Member.Status status;
    private long changed;
    private String uri;
    private long version = 1L;
    private Set<String> failures = new HashSet<String>();

    public MemberInfo() {
    }

    public MemberInfo(String uri, Member.Type type, Member.Status status) {
        this(uri, type, status, 1L);
    }

    public MemberInfo(String uri, Member.Type type, Member.Status status, long version) {
        this.uri = uri;
        this.type = type;
        this.status = status;
        this.version = version;
    }

    public Member.Type type() {
        return this.type;
    }

    public Member.Status state() {
        return this.status;
    }

    public long changed() {
        return this.changed;
    }

    public String uri() {
        return this.uri;
    }

    public long version() {
        return this.version;
    }

    public MemberInfo version(long version) {
        this.version = version;
        return this;
    }

    public MemberInfo succeed() {
        if (this.type == Member.Type.PASSIVE && this.status != Member.Status.ALIVE) {
            this.failures.clear();
            this.status = Member.Status.ALIVE;
            this.changed = System.currentTimeMillis();
        }
        return this;
    }

    public MemberInfo fail(String uri) {
        if (this.type == Member.Type.PASSIVE) {
            this.failures.add(uri);
            if (this.status == Member.Status.ALIVE) {
                this.status = Member.Status.SUSPICIOUS;
                this.changed = System.currentTimeMillis();
            } else if (this.status == Member.Status.SUSPICIOUS && this.failures.size() >= 3) {
                this.status = Member.Status.DEAD;
                this.changed = System.currentTimeMillis();
            }
        }
        return this;
    }

    public void update(MemberInfo info) {
        if (info.uri().equals(this.uri)) {
            if (info.version() > this.version()) {
                this.version = info.version();
            }
            return;
        }
        if (info.version > this.version) {
            this.version = info.version;
            this.failures.clear();
            if (this.type == Member.Type.PASSIVE) {
                if (this.status != info.status) {
                    this.changed = System.currentTimeMillis();
                }
                this.status = info.status;
            }
        } else if (info.version == this.version) {
            if (info.status == Member.Status.SUSPICIOUS) {
                this.failures.addAll(info.failures);
                if (this.failures.size() >= 3) {
                    this.status = Member.Status.DEAD;
                    this.changed = System.currentTimeMillis();
                }
            } else if (info.status == Member.Status.DEAD) {
                this.status = Member.Status.DEAD;
                this.changed = System.currentTimeMillis();
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MemberInfo) {
            MemberInfo member = (MemberInfo)object;
            return member.uri.equals(this.uri) && member.type == this.type && member.status == this.status && member.version == this.version;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.type, this.status, this.version});
    }

    public String toString() {
        return String.format("MemberInfo[uri=%s, type=%s, state=%s, version=%d]", new Object[]{this.uri, this.type, this.status, this.version});
    }
}

